package Encounter.EncounterGame;

/* Class Name           : SettingUp
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   20 May 2000     Tom VanCourt    Added no-op even handlers.
*   08 Mar 2000     Tom VanCourt    Added a default constructor
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;
import java.io.*;

import Encounter.EncounterEnvironment.Area;
import Encounter.EncounterCharacters.EncounterCharacter;
import FrameworkRPG.Debug;
import FrameworkRPG.RolePlayingGame.*;

/** A state of Encounter game. Keeps game quiescent during startup.
* <p> Requirements: SDD 2.1.1
* <p> Design: SDD 3.4 State Model Decomposition.
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public class SettingUp extends EncounterGameState 
{
    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/
    
    /** Create a new state handler, holding the world steady during init.
    * @param    gameM       Game context.
    */
    public SettingUp( EncounterGame gameP )
        { super(gameP); }

    /*----------------------------------------------------------------------*\
    ** Encounter.EncounterGame.EncounterGameState interface
    \*----------------------------------------------------------------------*/

    /** Handle the event in which a character enters a new area.
    * @param    characterP      Character that's moving.
    * @param    areaP           Area into which character moves.
    * @param    encounteringP   <tt>true</tt> iff more than charcter is 
    *                           now in the area.
    */
    public void handleEvent( EncounterCharacter characterP, 
        Area areaP, boolean encounteringP ) 
    {
        // No op. Hold the game stable during initialization.
    }
}
