package Encounter.EncounterGame;

/* Class Name           : SettingQualities
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   13 May 2000     Tom VanCourt    Added entryActions, exitCleanup
*    4 May 2000     Tom VanCourt    Filled in per design spec
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;
import java.io.*;

import Encounter.EncounterCharacters.*;
import Encounter.EncounterGame.EncounterGameDisplays.*;
import FrameworkRPG.Debug;
import FrameworkRPG.RolePlayingGame.*;

/** The state of preparation of the player's character.
* <p> Requirements: SDD 2.1.1
* <p> Design: SDD 3.4 State Model Decomposition.
* <br> SDD 6.1.1 Detailed design of <i>RolePlayingGame</i> package
*
* <p> Design issues: <ul>
* <li> This class has the name shown in SDD 3.4, not the conflicting
*   name shown in SDD 6.1.1
* </ul>
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public class SettingQualities extends EncounterGameState
{
    /** User interface object that manages quality value updates. */
    protected EncounterDisplay displayI;

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Create a new state handler, waiting for game events to occur.
    * @param    gameM       Game context in which player waits.
    */
    public SettingQualities ( EncounterGame gameM )
    {
        super( gameM );                     // Standard state setup.

        displayI = SetQualityDisplay.showDisplay(      // Display player status
            EncounterCast.getEncounterCast().getThePlayerCharacter(),
            this);
    }

    /*----------------------------------------------------------------------*\
    ** FrameworkRPG.GameEnvironment.GameState interface
    \*----------------------------------------------------------------------*/

    // Perform any actions that need to happen upon entry into the state.
    public void entryActions()
    {
        super.entryActions();       // Handle superclass default actions.

        // Make the dialog modal, i.e. let the status display take over
        // all of the game's IO. This is unfriendly behavior. It is, however,
        // much easier than keeping the status display active at the same
        // time as the game window, and keeping the status display current
        // when game interactions change quality point values.
        displayI.setModal(true);
    }

    /** Shut down any state-dependent activities, release
    * any state-dependent resources. This is the last method called
    * before transitioning to another state.
    */
    public void exitCleanup()
    {
        displayI.forceQuit();       // Dismiss the update UI right now.
        super.exitCleanup();        // Finish generic cleanup
    }

    /** Handle the user events. The only defined event is the end of the
    * update session, with return to the Waiting state.
    *
    * @param        anEventP    The current event being handled.
    */
    public void handleEvent(AWTEvent anEventP)
    {
        gameI.setState( new Waiting( gameI ) );
    }
}
