package Encounter.EncounterGame;

/* Class Name           : ReportingEncounter
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   13 May 2000     Tom VanCourt    added entryActions, exitCleanup
*    4 May 2000     Tom VanCourt    Filled in per design spec
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;
import java.io.*;

import Encounter.EncounterCharacters.*;
import Encounter.EncounterGame.EncounterGameDisplays.*;
import FrameworkRPG.Debug;

/** A substate of Encountering game in which the result of the encounter
* is displayed and the game freezes waiting for the user to dismiss the
* window.
* <p> Requirements: SDD 2.1.1
* <p> Design: SDD 3.4 State Model Decomposition.
* 
* <p> Design issues: <ul>
* <li> This class has the name shown in SDD 3.4, not the conflicting
*   name shown in SDD 6.1.1
* </ul>
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public class ReportingEncounter extends EncounterGameState
{
    /** User interface object that manages quality value display. */
    protected EncounterDisplay displayI;

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Create a new state handler, waiting for game events to occur.
    * @param    gameM       Game context in which player waits.
    */
    public ReportingEncounter ( EncounterGame gameM )
    {
        super( gameM );                     // Standard state setup.

        displayI = EngagementDisplay.       // Display player status
            showDisplay(
                EncounterCast.getEncounterCast().getThePlayerCharacter(),
                this );
    }

    /*----------------------------------------------------------------------*\
    ** FrameworkRPG.GameEnvironment.GameState interface
    \*----------------------------------------------------------------------*/

    /** Perform any actions that need to happen upon entry into the state.
    */
    public void entryActions()
    {
        super.entryActions();       // Handle superclass default actions.

        // Make the dialog modal, i.e. let the status display take over
        // all of the game's IO. This is unfriendly behavior. It is, however,
        // much easier than keeping the status display active at the same
        // time as the game window, and keeping the status display current
        // when game interactions change quality point values.
        displayI.setModal(true);
    }

    /** Shut down any state-dependent activities, release
    * any state-dependent resources. This is the last method called
    * before transitioning to another state.
    */
    public void exitCleanup()
    {
        displayI.forceQuit();       // Dismiss the update UI right now.
        super.exitCleanup();        // Finish generic cleanup
    }

    /** Reverts to event handling in the particular state.
    * <p> Requirements:     SRS 2.1.1, 3.2.1.2
    * <p> Use case:         SRS 2.2.2
    * <p> Design:           SDD 3.4
    * @param    eventP  The current event being handled.
    */
    public void handleEvent( AWTEvent eventP )
    {
        gameI.setState( new Waiting( gameI ) );
    }
}
