package Encounter.EncounterGame;

/* Class Name           : EncounterGameState
* Version information   : Version 0.1
* Date                  : 03/20/2000
* Copyright Notice      : see below
* Edit history:
*   20 May 2000 Tom VanCourt    Added handleEvent in a form that 
*                               handles character movement, and one
*                               character events.
*    4 May 2000 Tom VanCourt    Filled in constructor and default 
*                               method bodies.
*   20 Mar 2000 Tom VanCourt    Initial coding.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import Encounter.EncounterEnvironment.Area;
import Encounter.EncounterCharacters.EncounterCharacter;
import FrameworkRPG.RolePlayingGame.*;

/** Encounter game state. This has event methods specific to the 
* Encounter instance of the Framework state object, but does not
* provide a concrete implementation.
* <p> Requirements:  SRS 3.2.AR.4.3, 3.2.AR.4.4, and 3.2.AR.4.6 are 
*   state-dependent behaviors, so this abstract class defines methods
*   for implementing the state dependencies. 
* <ul title="Design issues:">
* <li> This class is not specified in the design documentation.
*   It has been added to provide state-specific handling for the
*   UI button events showStatus and setQualities. The original model
*   said that raw UI button-press events down to this level. That 
*   is no longer a good idea, since the main UI objects are
*   encapsulated elsewhere.
* </ul>
* @author   Tom VanCourt
* @version  0.1
*/

public abstract class EncounterGameState extends GameState   
{
    /** Game being played. */
    protected EncounterGame gameI;

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Create a new state handler, waiting for game events to occur.
    * @param    gameM       Game context in which player waits.
    */
    protected EncounterGameState ( EncounterGame gameP )
    {
        gameI = gameP;
    }

    /*----------------------------------------------------------------------*\
    ** Interface defined by this class
    \*----------------------------------------------------------------------*/
    
    /** Handle any event involving only a single character.
    * Default is to end the game if the character's life points total 0.
    * @param    characterP      Character that's moving.
    * @param    areaP           Area into which character moves.
    * @param    encounteringP   <tt>true</tt> iff more than character is 
    *                           now in the area.
    */
    public void handleEvent( EncounterCharacter characterP ) 
    {
        if ( characterP.sumOfQualities() == 0.0f ) {
            // It's abrupt, but the spec doesn't talk about 
            // anything more graceful.
            System.out.println("Character " +
                characterP.getName() +
                " died. \n*** Game ends.\n");
            System.exit(0);
        }
    }

    /** Handle the event in which a character enters a new area.
    * Default is to start an engagement if another character is in the area.
    * @param    characterP      Character that's moving.
    * @param    areaP           Area into which character moves.
    * @param    encounteringP   <tt>true</tt> iff more than character is 
    *                           now in the area.
    */
    public void handleEvent( EncounterCharacter characterP, 
        Area areaP, boolean encounteringP ) 
    {
        if ( encounteringP )
            gameI.setState( new Engaging( gameI, characterP ) );
    }

    /** Handle the user interface event that occurs on a request to 
    * change the player's qualities. Default action is a no-op.
    */
    public void setQualities() {}

    /** Handle the user interface event that occurs on a request to display
    * the player's game status. Default action is a no-op.
    */
    public void showStatus() {}
}
