package Encounter.EncounterGame.EncounterGameDisplays;

/* Class Name           : StartEngagement
* Version information   : Version 0.1
* Date                  : 05/13/2000
* Copyright Notice      : see below
* Edit history:
*   13 May 2000 Tom VanCourt    Initial coding. 
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;
import java.awt.event.*;

import Encounter.EncounterGame.*;

/** Announce the start of an engagement. 
* <p> This class is not described very explicitly in the design spec.
* Requirements allude to a period after the engagement begins,
* but before the transfer of points occurs (SRS 3.2.AR.4.3). During 
* that period, the user may try the 'set qualities' button to cut off
* the engagement. This class creates a screen display during that period.
*
* <p> Requirements:      SRS 3.2.PQ
*
* <p> Design issues: <ul>
* <li> This class is not explicitly described in the SDD.
* </ul>
* @author   Tom VanCourt
* @version  0.1
*/

public class StartEngagement extends Dialog 
{
    private static final Label captionS = new Label( "Engaging ..." );
    
    /*----------------------------------------------------------------------*\
    ** Constructor
    \*----------------------------------------------------------------------*/
    
    public StartEngagement( )
    {
        super(                                  // Create the dialog.
            EncounterGame.getTheEncounterGame().getMainFrame(),
            "Start engagement",                 // Dialog name
            false);                             // Do not show until set up.
            
        add( captionS );                        // Just an announcement
        setBackground(Color.white);

        pack();                                 // Pack dialog contents
        show();
    }
}
