package Encounter.EncounterGame.EncounterGameDisplays;

/* Class Name           : QualValueDisplay
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   10 Apr 2000 TOm VanCourt    Removed unused code.
*   10 Jan 2000 Tom VanCourt    Change to meet coding standards.
*                               Made default constructor refer to standard
*                               list of quality names.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;
import Encounter.EncounterCharacters.*;

/** Displays character qualities, allows one to be selected
* <p> Requirements: SRS 2.1.2.2 User Interface Concept for setting
*   quality value
*
* @author   Dr. Eric Braude
* @version  0.1
*/

class QualValueDisplay extends List
{
    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Default Constructor
    */
    public QualValueDisplay()
    {
        super(4, false); // show 4 items; 1 item double clickable

        // Get a copy of the quality names.
        String[] qualM = EncounterCharacter.getQualityTypes();
        for (int i = 0; i < qualM.length; i++) {
            // Capitalize (properly, Title-case) the quality name.
            // Note the assumption that each name is >= 2 characters long.
            String capName =
                Character.toTitleCase(qualM[i].charAt(0)) +
                qualM[i].substring(1).toLowerCase();

            addItem(capName);
        }
    }

    /*----------------------------------------------------------------------*\
    ** Self test interface
    \*----------------------------------------------------------------------*/

    /** Used for self test
    *
    * @param        argsP   Command line arguments.
    */
    public static void main(String[] argsP)
    {
        Dialog dM = new Dialog(new Frame(" [QualValueDisplay] "), 
            "-QualValueDisplay-", false);
        QualValueDisplay qM = new QualValueDisplay();
        dM.add(qM);
        dM.pack();
        dM.show();
    }
}
