package Encounter.EncounterGame.EncounterGameDisplays;

/* Class Name           : EncounterDisplay
* Version information   : Version 0.1
* Date                  : 07/02/2000
* Copyright Notice      : see below
* Edit history:
*   13 May 2000 Tom VanCourt    Moved forceQuit to this class
*    2 May 2000 Tom VanCourt    Original coding per design spec.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;
import java.awt.event.*;

import Encounter.EncounterCharacters.PlayerCharacter;
import Encounter.EncounterGame.EncounterGameState;
import FrameworkRPG.Debug;

/** Handle the logic common to all status/update dialogs
*
* <ul title="Design issues:">
* <li> Added to satisfy design statement 6.1.1.1; Needs proper elaboration
* </ul>
* @author   Tom VanCourt
* @version  0.1
*/

public abstract class EncounterDisplay extends Dialog
{
    protected EncounterGameState displayingStateI;
    
    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Basic constructor
    *
    * <p> Design:           6.1.1.1
    * @param        frameP      Frame that hosts the dialog
    * @param        nameP       Name of the dialog window
    * @param        showP       Is dialog visible?
    * @param        stateP      Game state that requested display
    */

    protected EncounterDisplay( Frame frameP, String nameP, 
        boolean showP, EncounterGameState stateP)
    {
        super( frameP, nameP, showP );

        displayingStateI = stateP;
        
        setLayout( new BorderLayout() );        // Main display layout.
    }
    
    /*----------------------------------------------------------------------*\
    ** Interface defined by this class
    \*----------------------------------------------------------------------*/

    /** Force the display to shut down immediately. */
    public void forceQuit()
        { }
}
