package Encounter.EncounterGame.EncounterGameDisplays;

/* Class Name           : CharacterCanvas
* Version information   : Version 0.1
* Date                  : 04/10/2000
* Copyright Notice      : see below
* Edit history:
*   11 Apr 2000 Tom VanCourt    initial coding
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;

import Encounter.EncounterCharacters.EncounterCharacter;

/** Simple canvas to display a character image.
*
* <p> Requirements:      SRS 3.2.ED, 3.2.PQ
*   This class handles the character image in any kind of dialog.
*
* <p> Design issues: <ul>
* <li> This class was not described in the design document.
* </ul>
*
* @author   Tom VanCourt
* @version  0.1
*/

class CharacterCanvas extends Canvas {

    private static final int
        CHARACTER_WIDTH = 50,               // Size for display
        CHARACTER_HEIGHT = 100;

    private EncounterCharacter characterI;  // Character to display

    /*----------------------------------------------------------------------*\
    ** Constructor
    \*----------------------------------------------------------------------*/

    /** Create a display area for showing a character image
    * @param    characterP      Character whose image is displayed.
    */
    public CharacterCanvas( EncounterCharacter characterP )
    {
        characterI = characterP;
        setSize( CHARACTER_WIDTH, CHARACTER_HEIGHT );
    }

    /*----------------------------------------------------------------------*\
    ** java.awt.Canvas interface
    \*----------------------------------------------------------------------*/

    /** Repaint the entire canvas.
    * @param    gP      Graphics context to use for display
    */
    public void paint(Graphics gP)          // Repaint the character.
    {
        Dimension sizeM = getSize();        // Canvas size
        characterI.showCharacter( this,     // Display in this canvas
            gP,
            new Point(sizeM.width/2, sizeM.height/2),
            sizeM.height, true);
    }
}

