package Encounter.EncounterEnvironment;

/* Class Name           : EncounterEnvironmentFactory
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   21 Jun 2000     Tom VanCourt    Changed graphic file root.
*   20 May 2000     Tom VanCourt    Added gameP parameter to makeArea
*   21 Feb 2000     Tom VanCourt    Work on area rendering. 
*    9 Feb 2000     Tom VanCourt    Added Hyperlink support.
*    8 Feb 2000     Tom VanCourt    Identify relationship to published design 
*                                   pattern, fix javadoc comments, 
*                                   enhance room creation.
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import Encounter.EncounterGame.EncounterGame;

/** Abstract factory for creating optional environments.
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public class EncounterEnvironmentFactory 
{
    /** Root directory for graphics files. */
    static final String FILE_ROOT = "Graphics/";
    
    /*----------------------------------------------------------------------*\
    ** Own interface
    \*----------------------------------------------------------------------*/

    /** Create an Area object with default dimension.
    *
    * @param        aNameP  The name of the area object.
    * @return               New area object.
    */
    public Area makeArea( String aNameP )
        { return makeArea( aNameP, null, null, new String[] {}, 1, 1 ); }
        
    /** Create an Area object with default dimension.
    *
    * @param    aNameP      The name of the area object.
    * @param    qualListP   Non-null list of quality names important
    *                           in this area.
    * @param    gameP       Game in which area exists
    * @param    imageFileP  File name of area's background image.
    * @return               New area object.
    */
    public Area makeArea( String aNameP, String imageFileP, 
        EncounterGame gameP, String[] qualListP )
    { 
        return makeArea( aNameP, imageFileP, gameP, qualListP, 1, 1 ); 
    }
        
    /** Create an Area object of a specified size. Dimensions are
    * in multiples of some unspecified grid cell. A 1x1 room is the 
    * smallest allowed, and is a comfortable size.
    *
    * @param    aNameP      The name of the area object.
    * @param    qualListP   Non-null list of quality names important 
    *                           in this area.
    * @param    imageFileP  File name of area's background image.
    * @param    gameP       Game in which area exists
    * @param    xSizeP      X (east/west) dimension, in grid cell widths.
    * @param    ySizeP      Y (north/south) dimesnion, in grid cell heights.
    * @return               New area object.
    */
    public Area makeArea( String aNameP, String imageFileP, 
        EncounterGame gameP, String[] qualListP, int xSizeP, int ySizeP )
    {
        return new Area( aNameP, FILE_ROOT + imageFileP, 
            gameP, qualListP, xSizeP, ySizeP );
    }

    /** Create an EncounterAreaConnection object.
    *
    * @param        Area1P  The first area to connect with this
    *                       EncounterAreaConnection object.
    * @param        Area2P  The second area to connect with this
    *                       EncounterAreaConnection object.
    * @return       Connection between the two areas
    */
    public EncounterAreaConnection 
        makeConnection( Area Area1P, Area Area2P )
    {
        return new EncounterAreaConnection( Area1P, Area2P );
    }
        
    /** Create a hyperlink to represent some connection.
    * @param    connectionP     Connection for which hyperlink is needed.
    * @param    nameP           Displayable string representing the link.
    * @return   New hyperlink object.
    */
    public Hyperlink makeHyperlink( 
        EncounterAreaConnection connectionP, String nameP )
    {
        return new Hyperlink( connectionP, nameP );
    }    
}
