package Encounter.EncounterCharacters;

/* Class Name           : EncounterCast
* Version information   : Version 0.1
* Date                  : 6/19/1999
* Copyright Notice      : see below
* Edit history:
*   11 Feb 2000     Tom VanCourt    Used simplified test interface.
*    8 Feb 2000     Tom VanCourt    Minor cleanup.
*   08 Jan 2000     Tom VanCourt    Change to conform to coding standards
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.io.*;
import java.util.*;

import FrameworkRPG.Debug;
import TestUtilities.*;

/** Facade class/object for the EncounterCharacters package. Used to 
* reference all characters of the Encounter game.
* <p> Design: SDD 3.1 Module decomposition
* <br> SDD 5.1.2 Interface to the EncounterCharacters package
*
* <p>Design issues:<ul>
* <li> SDD 5.1.2.4 method engagePlayerWithForeignCharacter was
*   not implemented, since engagements are handled more directly
*   from the Engaging state object.
* </ul>
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public class EncounterCast 
{
    /** Name for human player */
    private static final String MAIN_PLAYER_NAME = "Elena";
    
    /** Name of human's image */
    private static final String MAIN_PLAYER_IMAGE = "elena.gif";
    
    /** Name for foreign (machine) character */
    private static final String FOREIGN_PLAYER_NAME = "Freddie";
    
    /** Name of foreign character's image */
    private static final String FOREIGN_PLAYER_IMAGE = "freddie.gif";
    
    /** The only instance of EncounterCast */
    public static EncounterCast encounterCastS = new EncounterCast();

    /** Current player */
    private static PlayerCharacter playerS =
        PlayerCharacter.getMainPlayerCharacter( 
                MAIN_PLAYER_NAME, MAIN_PLAYER_IMAGE );

    /** Current foreign player */
    private static ForeignCharacter freddieS =
        ForeignCharacter.getForeignCharacter( 
            FOREIGN_PLAYER_NAME, FOREIGN_PLAYER_IMAGE );

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Private Constructor. This class should always be instantiated through
    * the getEncounterCast method.
    */
    private EncounterCast() 
        { super(); }

    /*----------------------------------------------------------------------*\
    ** Own interface
    \*----------------------------------------------------------------------*/

    /** Gets encounterCast, the one and only instance of EncounterCast.
    * <p> Requirement: SDD 5.1.2
    *
    * @return       The EncounterCast singleton.
    */
    public static EncounterCast getEncounterCast()
        { return encounterCastS; }

    /** Gets the one and only instance of ForeignCharacter.
    * <p> Requirement: SDD 5.1.2
    *
    * @return       The foreign character.
    */
    public static ForeignCharacter getTheForeignCharacter() 
        { return freddieS; }

    /** Gets the one and only instance of PlayerCharacter.
    * <p> Requirement: SDD 5.1.2
    *
    * @return       PlayerCharacter
    */
    public static PlayerCharacter getThePlayerCharacter() 
        { return playerS; }

    /*----------------------------------------------------------------------*\
    ** Test interface
    \*----------------------------------------------------------------------*/

    /** Get file name for test results and execute the test.
    *
    * @param        String[] Command line arguments.
    */
    public static void main( String[] argsP ) 
    {
        boolean openedM = false;                    // Assume we don't open a log
        
        if ( argsP != null && argsP.length > 0 ) {  // If log file is specified, 
            TestExecution.openTestLog( argsP[0] );  // then open it.
            openedM = true;
        }
        
        testForEncounterCharacterClass();
        
        if ( openedM )                              // If we opened a file,
            TestExecution.closeTestLog();           // close it. 
    }

    /** Tests all the methods of this class*/
    private static void testForEncounterCharacterClass( )
    {
        TestExecution.printTitle(                   // Title the log entries.
            "Encounter.EncounterCharacters.EncounterCast" );  
        TestExecution.printReportToFile( "Test of getThePlayerCharacter()",
            getThePlayerCharacter().getName(), MAIN_PLAYER_NAME );
        TestExecution.printReportToFile( "Test of getTheForeignCharacter()",
            getTheForeignCharacter().getName(), FOREIGN_PLAYER_NAME );
    }
}
