
package semorg.seminar;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;

/**
 * Objects of this class are representing seminars in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */
 
public class SeminarT extends Ancestor
{

  /**
   * Holds information about the seminar.
   */

  private String shortName;

  /**
   * Holds information about the seminar.
   */

  private String title;

  /**
   * Holds information about the seminar.
   */

  private String purpose;

  /**
   * Holds information about the seminar.
   */

  private String methodic;

  /**
   * Holds information about the seminar.
   */

  private String overview;

  /**
   * Holds information about the seminar.
   */

  private String dailyProcedure;

  /**
   * Holds information about the seminar.
   */

  private long durance;

  /**
   * Holds information about the seminar.
   */

  private String targetGroup;

  /**
   * Holds information about the seminar.
   */

  private String documentation;

  /**
   * Holds information about the seminar.
   */

  private String preconditions;

  /**
   * Holds information about the seminar.
   */

  private float charge;

  /**
   * Holds information about the seminar.
   */

  private long participiantMax;

  /**
   * Holds information about the seminar.
   */

  private long participiantMin;


  /**
   * The list of qualified docents.
   */

  private CanConductListT canConductList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public SeminarT()
  {
    shortName = "";
    title = "";
    purpose = "";
    methodic = "";
    overview = "";
    dailyProcedure = "";
    durance = 0;
    targetGroup = "";
    documentation = "";
    preconditions = "";
    charge = 0.0f;
    participiantMax = 0;
    participiantMin = 0;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public SeminarT(String shortName, String title, String purpose, String methodic, String overview, String dailyProcedure, long durance, String targetGroup, String documentation, String preconditions, float charge, long participiantMax, long participiantMin)
  {
    this.shortName = shortName;
    this.title = title;
    this.purpose = purpose;
    this.methodic = methodic;
    this.overview = overview;
    this.dailyProcedure = dailyProcedure;
    this.durance = durance;
    this.targetGroup = targetGroup;
    this.documentation = documentation;
    this.preconditions = preconditions;
    this.charge = charge;
    this.participiantMax = participiantMax;
    this.participiantMin = participiantMin;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from 
   *            the database.
   * @param column starting column from which to read data.
   */

  public SeminarT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      shortName = SQL.getString(Column); Column++;
      title = SQL.getString(Column); Column++;
      purpose = SQL.getString(Column); Column++;
      methodic = SQL.getString(Column); Column++;
      overview = SQL.getString(Column); Column++;
      dailyProcedure = SQL.getString(Column); Column++;
      durance = SQL.getLong(Column); Column++;
      targetGroup = SQL.getString(Column); Column++;
      documentation = SQL.getString(Column); Column++;
      preconditions = SQL.getString(Column); Column++;
      charge = SQL.getFloat(Column); Column++;
      participiantMax = SQL.getLong(Column); Column++;
      participiantMin = SQL.getLong(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 13;
  }

  /**
   * Returns string representation that is used for creating the corresponding 
   * table in the database.
   * 
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "ShortName varchar(10), " +
           prefix + "Title varchar(200), " +
           prefix + "Purpose varchar(400), " +
           prefix + "Methodic varchar(400), " +
           prefix + "Overview varchar(400), " +
           prefix + "DailyProcedure varchar(200), " +
           prefix + "Durance int, " +
           prefix + "TargetGroup varchar(200), " +
           prefix + "Documentation varchar(200), " +
           prefix + "Preconditions varchar(200), " +
           prefix + "Charge float, " +
           prefix + "ParticipiantMax int, " +
           prefix + "ParticipiantMin int, " +
           prefix + "CONSTRAINT PK_Seminar PRIMARY KEY (ShortName)";
  }

  public String toSQLAddString()
  {
    return "'" + getShortName() + "', " +
           "'" + getTitle() + "', " +
           "'" + getPurpose() + "', " +
           "'" + getMethodic() + "', " +
           "'" + getOverview() + "', " +
           "'" + getDailyProcedure() + "', " +
           getDurance() + ", " +
           "'" + getTargetGroup() + "', " +
           "'" + getDocumentation() + "', " +
           "'" + getPreconditions() + "', " +
           getCharge() + ", " +
           getParticipiantMax() + ", " +
           getParticipiantMin();
  }

  public String toSQLModifyString(String prefix)
  {
    return prefix + "ShortName = '" + getShortName() + "', " +
           prefix + "Title = '" + getTitle() + "', " +
           prefix + "Purpose = '" + getPurpose() + "', " +
           prefix + "Methodic = '" + getMethodic() + "', " +
           prefix + "Overview = '" + getOverview() + "', " +
           prefix + "DailyProcedure = '" + getDailyProcedure() + "', " +
           prefix + "Durance = " + getDurance() + ", " +
           prefix + "TargetGroup = '" + getTargetGroup() + "', " +
           prefix + "Documentation = '" + getDocumentation() + "', " +
           prefix + "Preconditions = '" + getPreconditions() + "', " +
           prefix + "Charge = " + getCharge() + ", " +
           prefix + "ParticipiantMax = " + getParticipiantMax() + ", " +
           prefix + "ParticipiantMin = " + getParticipiantMin();
  }

  public String toString()
  {
    return "Seminar: " + title;
  }

  /**
   * Returns short name of the seminar.
   * 
   * @return short name of the seminar.
   */

  public String getShortName()
  {
    return shortName;
  }

  /**
   * Returns title of the seminar.
   * 
   * @return title of the seminar.
   */

  public String getTitle()
  {
    return title;
  }

  /**
   * Returns purpose of the seminar.
   * 
   * @return purpose of the seminar.
   */

  public String getPurpose()
  {
    return purpose;
  }

  /**
   * Returns methodic of the seminar.
   * 
   * @return methodic of the seminar.
   */

  public String getMethodic()
  {
    return methodic;
  }

  /**
   * Returns overview of the seminar.
   * 
   * @return overview of the seminar.
   */

  public String getOverview()
  {
    return overview;
  }

  /**
   * Returns daily procedure of the seminar.
   * 
   * @return daily procedure of the seminar.
   */

  public String getDailyProcedure()
  {
    return dailyProcedure;
  }

  /**
   * Returns durance of the seminar.
   * 
   * @return durance of the seminar.
   */

  public long getDurance()
  {
    return durance;
  }

  /**
   * Returns target group of the seminar.
   * 
   * @return target group of the seminar.
   */

  public String getTargetGroup()
  {
    return targetGroup;
  }

  /**
   * Returns documentation of the seminar.
   * 
   * @return documentation of the seminar.
   */

  public String getDocumentation()
  {
    return documentation;
  }

  /**
   * Returns preconditons of the seminar.
   * 
   * @return preconditions of the seminar.
   */

  public String getPreconditions()
  {
    return preconditions;
  }

  /**
   * Returns charge of the seminar.
   * 
   * @return charge of the seminar.
   */

  public float getCharge()
  {
    return charge;
  }

  /**
   * Returns participiant max of the seminar.
   * 
   * @return participiant max of the seminar.
   */

  public long getParticipiantMax()
  {
    return participiantMax;
  }

  /**
   * Returns participiant min of the seminar.
   * 
   * @return participiant min of the seminar.
   */

  public long getParticipiantMin()
  {
    return participiantMin;
  }

  /**
   * Sets short name of a seminar.
   * 
   * @param value new value.
   */

  public void setShortName(String value)
  {
    shortName = value;
  }

  /**
   * Sets title of a seminar.
   * 
   * @param value new value.
   */

  public void setTitle(String value)
  {
    title = value;
  }

  /**
   * Sets purpose of a seminar.
   * 
   * @param value new value.
   */

  public void setPurpose(String value)
  {
    purpose = value;
  }

  /**
   * Sets methodic of a seminar.
   * 
   * @param value new value.
   */

  public void setMethodic(String value)
  {
    methodic = value;
  }

  /**
   * Sets overview of a seminar.
   * 
   * @param value new value.
   */

  public void setOverview(String value)
  {
    overview = value;
  }

  /**
   * Sets daily procedure of a seminar.
   * 
   * @param value new value.
   */

  public void setDailyProcedure(String value)
  {
    dailyProcedure = value;
  }

  /**
   * Sets durance of a seminar.
   * 
   * @param value new value.
   */

  public void setDurance(long value)
  {
    durance = value;
  }

  /**
   * Sets target group of a seminar.
   * 
   * @param value new value.
   */

  public void setTargetGroup(String value)
  {
    targetGroup = value;
  }

  /**
   * Sets documentation of a seminar.
   * 
   * @param value new value.
   */

  public void setDocumentation(String value)
  {
    documentation = value;
  }

  /**
   * Sets preconditions of a seminar.
   * 
   * @param value new value.
   */

  public void setPreconditions(String value)
  {
    preconditions = value;
  }

  /**
   * Sets charge of a seminar.
   * 
   * @param value new value.
   */

  public void setCharge(float value)
  {
    charge = value;
  }

  /**
   * Sets participiant max of a seminar.
   * 
   * @param value new value.
   */

  public void setParticipiantMax(long value)
  {
    participiantMax = value;
  }

  /**
   * Sets participiant min of a seminar.
   * 
   * @param value new value.
   */

  public void setParticipiantMin(long value)
  {
    participiantMin = value;
  }

  /**
   * Sets the link list for this booking.
   * 
   * @param value the link list for this booking
   */

  public void setCanConductList(CanConductListT value)
  {
    this.canConductList = value;
  }

  public Object getKey()
  {
    return getShortName();
  }

}
