
package semorg.seminar;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.person.ClientListT;

/**
 * Instances of this class represent list of elements that are contained in the 
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */
 
public class SeminarListT extends List
{

  /**
   * The associated list.
   */
   
  private ClientListT clientList;

  /**
   * The associated list.
   */
   
  private CanConductListT canConductList;

  /**
   * Creates a new instance associated with the database with the given 
   * connection.
   *
   * @param DBConnection connection with the database.
   */
   
  public SeminarListT(Connection DBConnection)
  {
    super(DBConnection);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */
   
  public SeminarListT(DataBaseT database)
  {
    super(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */
   
  private final String seminarTableName = "Seminar";

  /**
   * The primary key name of the table in which are elements stored in the 
   * database.
   */
   
  private final String seminarTableKeyName = "ShortName";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */
   
  public static final String tableColumns(String prefix)
  {
    return prefix + "ShortName, " +
           prefix + "Title, " +
           prefix + "Purpose, " +
           prefix + "Methodic, " +
           prefix + "Overview, " +
           prefix + "DailyProcedure, " +
           prefix + "Durance, " +
           prefix + "TargetGroup, " +
           prefix + "Documentation, " +
           prefix + "Preconditions, " +
           prefix + "Charge, " +
           prefix + "ParticipiantMax, " +
           prefix + "ParticipiantMin";
  }

  public String toString()
  {
    return "List of " + count() + " Seminars";
  }

  public boolean create()
  {
    return create(seminarTableName, SeminarT.SQLCreateString(""));
  }

  public boolean destroy()
  {
    return destroy(seminarTableName);
  }

  public boolean add(Ancestor element)
  {
    return add(seminarTableName, tableColumns(""), element.toSQLAddString());
  }

  public boolean remove(Object key)
  {
    return remove(seminarTableName, seminarTableKeyName, key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(seminarTableName, seminarTableKeyName, element.toSQLModifyString(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(seminarTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(seminarTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      SeminarT Seminar = new SeminarT(Result, 1);
      database.close(Result);
      Seminar.setCanConductList(canConductList);
      return Seminar;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(seminarTableName, seminarTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        SeminarT Seminar = new SeminarT(Result, 1);
        database.close(Result);
        Seminar.setCanConductList(canConductList);
        return Seminar;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */
   
  public void setCanConductList(CanConductListT value)
  {
    this.canConductList = value;
  }

}
