
package semorg.seminar;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.person.DocentListT;
import semorg.person.DocentT;

/**
 * Objects of this class are representing links betweanseminars and docents in
 * the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CanConductT extends Ancestor
{

  /**
   * Holds information about the link.
   */

  private Long docent;

  /**
   * Holds information about the link.
   */

  private String seminar;

  /**
   * Holds information about the link.
   */

  private SeminarListT seminarList;

  /**
   * The list of docents.
   */

  private DocentListT docentList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public CanConductT()
  {
    docent = null;
    seminar = null;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public CanConductT(Long docent, String seminar)
  {
    this.docent = docent;
    this.seminar = seminar;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public CanConductT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      docent = new Long(SQL.getLong(Column)); Column++;
      seminar = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 2;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "Docent int, " +
           prefix + "Seminar varchar(10), "+
           prefix + "CONSTRAINT PK_CanConduct PRIMARY KEY (Docent, Seminar)";
  }

  public String toSQLAddString()
  {
    return docent + ", " +
           "'" + seminar + "'";
  }

  public String toSQLModifyString(String prefix)
  {
    return prefix + "Docent = " + docent + ", " +
           prefix + "Seminar = '" + getSeminar() + "'";
  }

  public String toString()
  {
    if (getSeminar() != null)
    {
      return "Can Expertly Conduct " + getSeminar();
    }
    else
    {
      return "unspecified";
    }
  }

  /**
   * Returns docent of this link.
   *
   * @return docent of this link.
   */

  public DocentT getDocent()
  {
    if (docentList == null)
    {
      return null;
    }
    else
    {
      return (DocentT)docentList.find(docent);
    }
  }

  /**
   * Returns seminar of this link.
   *
   * @return seminar of this link.
   */

  public SeminarT getSeminar()
  {
    if (seminarList == null)
    {
      return null;
    }
    else
    {
      return (SeminarT)seminarList.find(seminar);
    }
  }

  /**
   * Sets docent of this link.
   *
   * @param value new value.
   */

  public void setDocent(DocentT value)
  {
    if (value != null)
    {
      docent = new Long(value.getIDNumber());
    }
    else
    {
      docent = null;
    }
  }

  /**
   * Sets docent of this link.
   *
   * @param value new value.
   */

  public void setDocent(Long value)
  {
    docent = value;
  }

  /**
   * Sets seminar of this link.
   *
   * @param value new value.
   */

  public void setSeminar(SeminarT value)
  {
    if (value != null)
    {
      seminar = value.getShortName();
    }
    else
    {
      seminar = null;
    }
  }

  /**
   * Sets seminar of this link.
   *
   * @param value new value.
   */

  public void setSeminar(String value)
  {
    seminar = value;
  }

  /**
   * Sets docent list for this link.
   *
   * @param value docent list for this link
   */

  public void setDocentList(DocentListT value)
  {
    this.docentList = value;
  }

  /**
   * Sets seminar list for this link.
   *
   * @param value seminar list for this link
   */

  public void setSeminarList(SeminarListT value)
  {
    this.seminarList = value;
  }

  public Object getKey()
  {
    return new CanConductKey(docent, seminar);
  }

}
