
package semorg.seminar;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.person.DocentListT;


/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CanConductListT extends List
{

  /**
   * The associated list.
   */

  private SeminarListT seminarList;

  /**
   * The associated list.
   */

  private DocentListT docentList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public CanConductListT(Connection DBConnection)
  {
    super(DBConnection);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public CanConductListT(DataBaseT database)
  {
    super(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String canConductTableName = "CanConduct";

  /**
   * First part of the primary key name of the table in which are elements
   * stored in the database.
   */

  private final String canConductTableKeyName1 = "Docent";

  /**
   * Second part of the primary key name of the table in which are elements
   * stored in the database.
   */

  private final String canConductTableKeyName2 = "Seminar";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "Docent, " +
           prefix + "Seminar";
  }

  public String toString()
  {
    return "List of " + count() + " CanConducts";
  }

  public boolean create()
  {
    return create(canConductTableName, CanConductT.SQLCreateString(""));
  }

  public boolean destroy()
  {
    return destroy(canConductTableName);
  }

  public boolean add(Ancestor element)
  {
    return add(canConductTableName, tableColumns(""), element.toSQLAddString());
  }

  public boolean remove(Object key)
  {
    CanConductKey myKey = (CanConductKey) key;
    return remove(canConductTableName, canConductTableKeyName1, myKey.getDocent(),
                                       canConductTableKeyName2, myKey.getSeminar());
  }

  public boolean modify(Ancestor element)
  {
    Object key1 = ((CanConductKey)element.getKey()).getDocent();
    Object key2 = ((CanConductKey)element.getKey()).getSeminar();
    boolean Ok = modify(canConductTableName, canConductTableKeyName1, canConductTableKeyName2, element.toSQLModifyString(""), key1, key2);
    if (!Ok)
    {
      Ok =add(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(canConductTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(canConductTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      CanConductT CanConduct = new CanConductT(Result, 1);
      database.close(Result);
      CanConduct.setDocentList(docentList);
      CanConduct.setSeminarList(seminarList);
      return CanConduct;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Parse primery key
    CanConductKey myKey = (CanConductKey) key;

    // Get data from database
    ResultSet Result = find(canConductTableName, canConductTableKeyName1, myKey.getDocent(),
                                                 canConductTableKeyName2, myKey.getSeminar());

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        CanConductT CanConduct = new CanConductT(Result, 1);
        database.close(Result);
        CanConduct.setDocentList(docentList);
        CanConduct.setSeminarList(seminarList);
        return CanConduct;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setDocentList(DocentListT value)
  {
    this.docentList = value;
  }

  public DocentListT getDocentList()
  {
    return docentList;
  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setSeminarList(SeminarListT value)
  {
    this.seminarList = value;
  }

  public SeminarListT getSeminarList()
  {
    return seminarList;
  }

}
