
package semorg.presentation;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.AddressT;
import semorg.classes.Ancestor;
import semorg.classes.DateT;
import semorg.classes.TimeT;
import semorg.seminar.SeminarListT;
import semorg.seminar.SeminarT;

/**
 * Objects of this class are representing presentations in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class PresentationT extends Ancestor
{

  /**
   * Holds information about the presentation.
   */

  private long IDNumber;

  /**
   * Holds information about the presentation.
   */

  private long durance;

  /**
   * Holds information about the presentation.
   */

  private DateT from;

  /**
   * Holds information about the presentation.
   */

  private DateT to;

  /**
   * Holds information about the presentation.
   */


  /**
   * Holds information about the presentation.
   */

  private TimeT dailyStart;

  /**
   * Holds information about the presentation.
   */

  private TimeT dailyEnd;

  /**
   * Holds information about the presentation.
   */

  private TimeT startFirstDay;

  /**
   * Holds information about the presentation.
   */

  private TimeT endLastDay;

  /**
   * Holds information about the presentation.
   */

  private String place;

  /**
   * Holds information about the presentation.
   */

  private AddressT address;

  /**
   * Holds information about the presentation.
   */

  private long participiantMax;

  /**
   * Holds information about the presentation.
   */

  private boolean canceled;

  /**
   * Holds information about the presentation.
   */

  private String seminarType;

  /**
   * The list of seminars.
   */

  private SeminarListT seminarList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public PresentationT()
  {
    IDNumber = 0;
    durance = 0;
    from = new DateT();
    to = new DateT();
    dailyStart = new TimeT();
    dailyEnd = new TimeT();
    startFirstDay = new TimeT();
    endLastDay = new TimeT();
    place = "";
    address = new AddressT();
    participiantMax = 0;
    canceled = true;
    seminarType = null;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public PresentationT(long IDNumber, long durance, DateT from, DateT to, TimeT dailyStart, TimeT dailyEnd, TimeT startFirstDay, TimeT endLastDay, String place, AddressT address, long participiantMax, boolean canceled, String seminarType)
  {
    this.IDNumber = IDNumber;
    this.durance = durance;
    this.from = from;
    this.to = to;
    this.dailyStart = dailyStart;
    this.dailyEnd = dailyEnd;
    this.startFirstDay = startFirstDay;
    this.endLastDay = endLastDay;
    this.place = place;
    this.address = address;
    this.participiantMax = participiantMax;
    this.canceled = canceled;
    this.seminarType = seminarType;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public PresentationT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      IDNumber = SQL.getLong(Column); Column++;
      durance = SQL.getLong(Column); Column++;
      from = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      to = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      dailyStart = new TimeT(SQL, Column); Column += TimeT.noOfSQLColumns();
      dailyEnd = new TimeT(SQL, Column); Column += TimeT.noOfSQLColumns();
      startFirstDay = new TimeT(SQL, Column); Column += TimeT.noOfSQLColumns();
      endLastDay = new TimeT(SQL, Column); Column += TimeT.noOfSQLColumns();
      place = SQL.getString(Column); Column++;
      address = new AddressT(SQL, Column); Column += AddressT.noOfSQLColumns();
      participiantMax = SQL.getLong(Column); Column++;
      canceled = SQL.getBoolean(Column); Column++;
      seminarType = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 6 + AddressT.noOfSQLColumns() + 2 * DateT.noOfSQLColumns() + 4 * TimeT.noOfSQLColumns();
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "Durance int, " +
           DateT.SQLCreateString(prefix + "xFrom") + ", " +    
           DateT.SQLCreateString(prefix + "xTo") + ", " +    
           TimeT.SQLCreateString(prefix + "DailyStart") + ", " +    
           TimeT.SQLCreateString(prefix + "DailyEnd") + ", " +    
           TimeT.SQLCreateString(prefix + "StartFirstDay") + ", " +    
           TimeT.SQLCreateString(prefix + "EndLastDay") + ", " +    
           prefix + "Place varchar(50), " +
           AddressT.SQLCreateString(prefix) + ", " +
           prefix + "ParticipiantMax int, " +
           prefix + "Canceled int, " +
           prefix + "SeminarType varchar(10), " +
           prefix + "CONSTRAINT PK_Presentetion PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddString()
  {
    return getIDNumber() + ", " +
           getDurance() + ", " +
           getFrom().toSQLAddString() + ", " +
           getTo().toSQLAddString() + ", " +
           getDailyStart().toSQLAddString() + ", " +
           getDailyEnd().toSQLAddString() + ", " +
           getStartFirstDay().toSQLAddString() + ", " +
           getEndLastDay().toSQLAddString() + ", " +
           "'" + getPlace() + "', " +
           getAddress().toSQLAddString() + ", " +
           getParticipiantMax() + ", " +
           (getCanceled() ? "1" : "0") + ", " +
           ((this.seminarType != null) ? "'" + this.seminarType.toString() + "'" : "NULL");
  }

  public String toSQLModifyString(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "Durance = " + getDurance() + ", " +
           getFrom().toSQLModifyString(prefix + "xFrom") + ", " + 
           getTo().toSQLModifyString(prefix + "xTo") + ", " + 
           getDailyStart().toSQLModifyString(prefix + "DailyStart") + ", " + 
           getDailyEnd().toSQLModifyString(prefix + "DailyEnd") + ", " + 
           getStartFirstDay().toSQLModifyString(prefix + "StartFirstDay") + ", " + 
           getEndLastDay().toSQLModifyString(prefix + "EndLastDay") + ", " + 
           prefix + "Place = '" + getPlace() + "', " +
           getAddress().toSQLModifyString(prefix) + ", " +
           prefix + "ParticipiantMax = " + getParticipiantMax() + ", " +
           prefix + "Canceled = " + (getCanceled() ? "1" : "0") + ", " +
           prefix + "SeminarType = " + ((this.seminarType != null) ? "'" + this.seminarType.toString() + "'" : "NULL");
  }

  public String toString()
  {
    return "Presentation: " + getPlace();
  }

  /**
   * Returns identification of the presentation.
   *
   * @return identification of the presentation.
   */

  public long getIDNumber()
  {
    return IDNumber;
  }

  /**
   * Returns durance of the presentation.
   *
   * @return durance of the presentation.
   */

  public long getDurance()
  {
    return durance;
  }

  /**
   * Returns start date of the presentation.
   *
   * @return start date of the presentation.
   */

  public DateT getFrom()
  {
    return from;
  }

  /**
   * Returns end date of the presentation.
   *
   * @return end date of the presentation.
   */

  public DateT getTo()
  {
    return to;
  }

  /**
   * Returns starting time of the presentation.
   *
   * @return starting time of the presentation.
   */

  public TimeT getDailyStart()
  {
    return dailyStart;
  }

  /**
   * Returns ending time of the presentation.
   *
   * @return ending time of the presentation.
   */

  public TimeT getDailyEnd()
  {
    return dailyEnd;
  }

  /**
   * Returns starting date and time of the presentation.
   *
   * @return starting date and time of the presentation.
   */

  public TimeT getStartFirstDay()
  {
    return startFirstDay;
  }

  /**
   * Returns ending date and time of the presentation.
   *
   * @return ending date and time of the presentation.
   */

  public TimeT getEndLastDay()
  {
    return endLastDay;
  }

  /**
   * Returns place of the presentation.
   *
   * @return place of the presentation.
   */

  public String getPlace()
  {
    return place;
  }

  /**
   * Returns address of the presentation.
   *
   * @return address of the presentation.
   */

  public AddressT getAddress()
  {
    return address;
  }

  /**
   * Returns participiant max of the presentation.
   *
   * @return participiant max of the presentation.
   */

  public long getParticipiantMax()
  {
    return participiantMax;
  }

  /**
   * Returns cancelation state of the presentation.
   *
   * @return cancelation state of the presentation.
   */

  public boolean getCanceled()
  {
    return canceled;
  }

  /**
   * Returns seminar to which the presentation belongs.
   *
   * @return seminar to which the presentation belongs.
   */

  public SeminarT getSeminar()
  {
    if (seminarList == null)
    {
      return null;
    }
    else if (seminarType == null)
    {
      return null;
    }
    else
    {
      return (SeminarT) seminarList.find(seminarType);
    }
  }

  /**
   * Sets identification of a presentation.
   *
   * @param value new value.
   */

  public void setIDNumber(long value)
  {
    IDNumber = value;
  }

  /**
   * Sets durance of a presentation.
   *
   * @param value new value.
   */

  public void setDurance(long value)
  {
    durance = value;
  }

  /**
   * Sets starting date of a presentation.
   *
   * @param value new value.
   */

  public void setFrom(DateT value)
  {
    from = value;
  }

  /**
   * Sets ending date of a presentation.
   *
   * @param value new value.
   */

  public void setTo(DateT value)
  {
    to = value;
  }

  /**
   * Sets starting time of a presentation.
   *
   * @param value new value.
   */

  public void setDailyStart(TimeT value)
  {
    dailyStart = value;
  }

  /**
   * Sets ending time of a presentation.
   *
   * @param value new value.
   */

  public void setDailyEnd(TimeT value)
  {
    dailyEnd = value;
  }

  /**
   * Sets starting date and time of a presentation.
   *
   * @param value new value.
   */

  public void setStartFirstDay(TimeT value)
  {
    startFirstDay = value;
  }

  /**
   * Sets ending date and time of a presentation.
   *
   * @param value new value.
   */

  public void setEndLastDay(TimeT value)
  {
    endLastDay = value;
  }

  /**
   * Sets place of a presentation.
   *
   * @param value new value.
   */

  public void setPlace(String value)
  {
    place = value;
  }

  /**
   * Sets address of a presentation.
   *
   * @param value new value.
   */

  public void setAddress(AddressT value)
  {
    address = value;
  }

  /**
   * Sets participiants max of a presentation.
   *
   * @param value new value.
   */

  public void setParticipiantMax(long value)
  {
    participiantMax = value;
  }

  /**
   * Sets cancelation state of a presentation.
   *
   * @param value new value.
   */

  public void setCanceled(boolean value)
  {
    canceled = value;
  }

  /**
   * Sets seminar to which the presentation belongs.
   *
   * @param value new value.
   */

  public void setSeminar(SeminarT value)
  {
    if (value != null)
    {
      seminarType = value.getShortName();
    }
    else
    {
      seminarType = null;
    }
  }

  /**
   * Sets seminar to which the presentation belongs.
   *
   * @param value new value.
   */

  public void setSeminar(String value)
  {
    seminarType = value;
  }

  /**
   * Sets seminar list for this booking.
   *
   * @param value seminar list for this booking
   */

  public void setSeminarList(SeminarListT value)
  {
    this.seminarList = value;
  }

  public Object getKey()
  {
    return new Long( getIDNumber() );
  }

}
