
package semorg.presentation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.AddressT;
import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.DateT;
import semorg.classes.List;
import semorg.classes.TimeT;
import semorg.seminar.SeminarListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class PresentationListT extends List
{

  /**
   * The associated list.
   */

  private SeminarListT seminarList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public PresentationListT(Connection DBConnection)
  {
    super(DBConnection);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public PresentationListT(DataBaseT database)
  {
    super(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String presentationTableName = "Presentation";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String presentationTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "Durance, " +
           DateT.tableColumns(prefix + "xFrom") + ", " +
           DateT.tableColumns(prefix + "xTo") + ", " +
           TimeT.tableColumns(prefix + "DailyStart") + ", " +
           TimeT.tableColumns(prefix + "DailyEnd") + ", " +
           TimeT.tableColumns(prefix + "StartFirstDay") + ", " +
           TimeT.tableColumns(prefix + "EndLastDay") + ", " +
           prefix + "Place, " +
           AddressT.tableColumns(prefix) + ", " +
           prefix + "ParticipiantMax, " +
           prefix + "Canceled, " +
           prefix + "SeminarType";
  }

  public String toString()
  {
    return "List of " + count() + " Presentations";
  }

  public boolean create()
  {
    return create(presentationTableName, PresentationT.SQLCreateString(""));
  }

  public boolean destroy()
  {
    return destroy(presentationTableName);
  }

  public boolean add(Ancestor element)
  {
    return add(presentationTableName, tableColumns(""), element.toSQLAddString());
  }

  public boolean remove(Object key)
  {
    return remove(presentationTableName, presentationTableKeyName, key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(presentationTableName, presentationTableKeyName, element.toSQLModifyString(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(presentationTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(presentationTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      PresentationT Presentation = new PresentationT(Result, 1);
      database.close(Result);
      Presentation.setSeminarList(seminarList);
      return (Ancestor) Presentation;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(presentationTableName, presentationTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        PresentationT Presentation = new PresentationT(Result, 1);
        database.close(Result);
        Presentation.setSeminarList(seminarList);
        return (Ancestor) Presentation;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setSeminarList(SeminarListT value)
  {
    this.seminarList = value;
  }

  public SeminarListT getSeminarList()
  {
    return seminarList;
  }

}
