
package semorg.presentation;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.AddressT;
import semorg.classes.DateT;
import semorg.classes.TimeT;

/**
 * Objects of this class are representing presentations in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CompanyPresentationT extends PresentationT
{

  /**
   * Holds information about the presentation.
   */

  private float globalPrice;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public CompanyPresentationT()
  {
    super();
    globalPrice = 0.0f;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public CompanyPresentationT(long IDNumber, long durance, DateT from, DateT to, TimeT dailyStart, TimeT dailyEnd, TimeT startFirstDay, TimeT endLastDay, String place, AddressT address, long participiantMax, boolean canceled, float globalPrice,  String seminarType)
  {
    super(IDNumber, durance, from, to, dailyStart, dailyEnd, startFirstDay, endLastDay, place, address, participiantMax, canceled,  seminarType);
    this.globalPrice = globalPrice;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public CompanyPresentationT(ResultSet SQL, int Column)
  {
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      globalPrice = SQL.getFloat(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assigns all atributes from the given presentation.
   *
   * @param person object containing values to be assigned to atributes.
   */

  public void assignFromPresentation(PresentationT presentation)
  {
    if ((presentation != null) && (presentation.getIDNumber() == getIDNumber()))
    {
      setDurance(presentation.getDurance());
      setFrom(presentation.getFrom());
      setTo(presentation.getTo());
      setDailyStart(presentation.getDailyStart());
      setDailyEnd(presentation.getDailyEnd());
      setStartFirstDay(presentation.getStartFirstDay());
      setEndLastDay(presentation.getEndLastDay());
      setPlace(presentation.getPlace());
      setAddress(presentation.getAddress());
      setParticipiantMax(presentation.getParticipiantMax());
      setCanceled(presentation.getCanceled());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 2;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "GlobalPrice float, " +
           prefix + "CONSTRAINT PK_CompanyPresentetion PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           getGlobalPrice();
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "GlobalPrice = " + getGlobalPrice();
  }

  /**
   * Returns global price of a presentation.
   *
   * @return global price of a presentation.
   */

  public float getGlobalPrice()
  {
    return globalPrice;
  }

  /**
   * Sets global price of a presentation.
   *
   * @param value new value.
   */

  public void setGlobalPrice(float value)
  {
    globalPrice = value;
  }

}
