
package semorg.presentation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.seminar.SeminarListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CompanyPresentationListT extends List
{

  /**
   * The associated list.
   */

  private PresentationListT presentationList;

  /**
   * The associated list.
   */

  private SeminarListT seminarList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public CompanyPresentationListT(Connection DBConnection)
  {
    super(DBConnection);
    this.presentationList = new PresentationListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public CompanyPresentationListT(DataBaseT database)
  {
    super(database);
    this.presentationList = new PresentationListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String companyPresentationTableName = "CompanyPresentation";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String companyPresentationTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "GlobalPrice";
  }

  public String toString()
  {
    return "List of " + count() + " CompanyPresentations";
  }

  public boolean create()
  {
    presentationList.create();
    return create(companyPresentationTableName, CompanyPresentationT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(companyPresentationTableName);
  }

  public boolean add(Ancestor element)
  {
    return presentationList.add(element) &&
           add(companyPresentationTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return remove(companyPresentationTableName, companyPresentationTableKeyName, key) &&
           presentationList.remove(key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(companyPresentationTableName, companyPresentationTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = presentationList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(companyPresentationTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(companyPresentationTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      CompanyPresentationT CompanyPresentation = new CompanyPresentationT(Result, 1);
      CompanyPresentation.assignFromPresentation((PresentationT)presentationList.find(CompanyPresentation.getKey()));
      database.close(Result);
      CompanyPresentation.setSeminarList(seminarList);
      return CompanyPresentation;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(companyPresentationTableName, companyPresentationTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        CompanyPresentationT CompanyPresentation = new CompanyPresentationT(Result, 1);
        CompanyPresentation.assignFromPresentation((PresentationT)presentationList.find(key));
        database.close(Result);
        CompanyPresentation.setSeminarList(seminarList);
        return CompanyPresentation;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setSeminarList(SeminarListT value)
  {
    this.seminarList = value;
  }

}
