
package semorg.presentation;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.AddressT;
import semorg.classes.DateT;
import semorg.classes.TimeT;

/**
 * Objects of this class are representing presentations in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class ClientPresentationT extends PresentationT
{

  /**
   * Holds information about the presentation.
   */

  private String partner;

  /**
   * Holds information about the presentation.
   */

  private float cancelFee;

  /**
   * Holds information about the presentation.
   */

  private long participiantMin;

  /**
   * Holds information about the presentation.
   */

  private long participiantActual;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public ClientPresentationT()
  {
    super();
    partner = "";
    cancelFee = 0.0f;
    participiantMin = 0;
    participiantActual = 0;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public ClientPresentationT(long IDNumber, long durance, DateT from, DateT to, TimeT dailyStart, TimeT dailyEnd, TimeT startFirstDay, TimeT endLastDay, String place, AddressT address, long participiantMax, boolean canceled, String partner, float cancelFee, long participiantMin, long participiantActual,  String seminarType)
  {
    super(IDNumber, durance, from, to, dailyStart, dailyEnd, startFirstDay, endLastDay, place, address, participiantMax, canceled,  seminarType);
    this.partner = partner;
    this.cancelFee = cancelFee;
    this.participiantMin = participiantMin;
    this.participiantActual = participiantActual;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public ClientPresentationT(ResultSet SQL, int Column)
  {
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      partner = SQL.getString(Column); Column++;
      cancelFee = SQL.getFloat(Column); Column++;
      participiantMin = SQL.getLong(Column); Column++;
      participiantActual = SQL.getLong(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assigns all atributes from the given presentation.
   *
   * @param person object containing values to be assigned to atributes.
   */

  public void assignFromPresentation(PresentationT presentation)
  {
    if ((presentation != null) && (presentation.getIDNumber() == getIDNumber()))
    {
      setDurance(presentation.getDurance());
      setFrom(presentation.getFrom());
      setTo(presentation.getTo());
      setDailyStart(presentation.getDailyStart());
      setDailyEnd(presentation.getDailyEnd());
      setStartFirstDay(presentation.getStartFirstDay());
      setEndLastDay(presentation.getEndLastDay());
      setPlace(presentation.getPlace());
      setAddress(presentation.getAddress());
      setParticipiantMax(presentation.getParticipiantMax());
      setCanceled(presentation.getCanceled());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 5;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "Partner varchar(100), " +
           prefix + "CancelFee float, " +
           prefix + "ParticipiantMin int, " +
           prefix + "ParticipiantActual int, " +
           prefix + "CONSTRAINT PK_ClientPresentetion PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           "'" + getPartner() + "', " +
           getCancelFee() + ", " +
           getParticipiantMin() + ", " +
           getParticipiantActual();
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "Partner = '" + getPartner() + "', " +
           prefix + "CancelFee = " + getCancelFee() + ", " +
           prefix + "ParticipiantMin = " + getParticipiantMin() + ", " +
           prefix + "ParticipiantActual = " + getParticipiantActual();
  }

  /**
   * Returns partner of a presentation.
   *
   * @return partner of a presentation.
   */

  public String getPartner()
  {
    return partner;
  }

  /**
   * Returns cancel fee of a presentation.
   *
   * @return cancel fee of a presentation.
   */

  public float getCancelFee()
  {
    return cancelFee;
  }

  /**
   * Returns participiant min of a presentation.
   *
   * @return participiant min of a presentation.
   */

  public long getParticipiantMin()
  {
    return participiantMin;
  }

  /**
   * Returns participiant actual of a presentation.
   *
   * @return participiant actual of a presentation.
   */

  public long getParticipiantActual()
  {
    return participiantActual;
  }

  /**
   * Sets partner of a presentation.
   *
   * @param value new value.
   */

  public void setPartner(String value)
  {
    partner = value;
  }

  /**
   * Sets cancel fee of a presentation.
   *
   * @param value new value.
   */

  public void setCancelFee(float value)
  {
    cancelFee = value;
  }

  /**
   * Sets participiant min of a presentation.
   *
   * @param value new value.
   */

  public void setParticipiantMin(long value)
  {
    participiantMin = value;
  }

  /**
   * Sets participiant actual of a presentation.
   *
   * @param value new value.
   */

  public void setParticipiantActual(long value)
  {
    participiantActual = value;
  }

}
