
package semorg.presentation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.seminar.SeminarListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class ClientPresentationListT extends List
{

  /**
   * The associated list.
   */

  private PresentationListT presentationList;

  /**
   * The associated list.
   */

  private SeminarListT seminarList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public ClientPresentationListT(Connection DBConnection)
  {
    super(DBConnection);
    this.presentationList = new PresentationListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public ClientPresentationListT(DataBaseT database)
  {
    super(database);
    this.presentationList = new PresentationListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String clientPresentationTableName = "ClientPresentation";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String clientPresentationTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "Partner, " +
           prefix + "CancelFee, " +
           prefix + "ParticipiantMin, " +
           prefix + "ParticipiantActual";
  }

  public String toString()
  {
    return "List of " + count() + " ClientPresentations";
  }

  public boolean create()
  {
    presentationList.create();
    return create(clientPresentationTableName, ClientPresentationT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(clientPresentationTableName);
  }

  public boolean destroy(boolean all)
  {
    destroy(clientPresentationTableName);
    return destroy("Presentation");
  }

  public boolean add(Ancestor element)
  {
    return presentationList.add(element) &&
           add(clientPresentationTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return remove(clientPresentationTableName, clientPresentationTableKeyName, key) &&
           presentationList.remove(key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(clientPresentationTableName, clientPresentationTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = presentationList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(clientPresentationTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(clientPresentationTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      ClientPresentationT ClientPresentation = new ClientPresentationT(Result, 1);
      ClientPresentation.assignFromPresentation( (PresentationT) presentationList.find(ClientPresentation.getKey()));
      database.close(Result);
      ClientPresentation.setSeminarList(seminarList);
      return ClientPresentation;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(clientPresentationTableName, clientPresentationTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        ClientPresentationT ClientPresentation = new ClientPresentationT(Result, 1);
        ClientPresentation.assignFromPresentation( (PresentationT) presentationList.find(key));
        database.close(Result);
        ClientPresentation.setSeminarList(seminarList);
        return ClientPresentation;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setSeminarList(SeminarListT value)
  {
    this.seminarList = value;
  }

}
