
package semorg.person;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.AddressT;
import semorg.classes.Ancestor;
import semorg.classes.ContactT;
import semorg.classes.DateT;
import semorg.classes.NameT;

/**
 * Objects of this class are representing persons in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class PersonT extends Ancestor
{

  /**
   * Holds information about the person.
   */

  private long IDNumber;

  /**
   * Holds information about the associate.
   */

  private NameT name;

  /**
   * Holds information about the associate.
   */

  private ContactT contact;

  /**
   * Holds information about the associate.
   */

  private DateT birthday;

  /**
   * Holds information about the associate.
   */

  private DateT dayRegistered;

  /**
   * Holds information about the associate.
   */

  private String shortInformation;

  /**
   * Holds information about the associate.
   */

  private String notices;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public PersonT()
  {
    IDNumber = 0;
    name = new NameT();
    contact = new ContactT();
    birthday = new DateT();
    dayRegistered = new DateT();
    shortInformation = "";
    notices = "";
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public PersonT(long IDNumber, NameT name, ContactT contact,
                 DateT birthday, DateT dayRegistered,
                 String shortInformation, String notices)
  {
    this.IDNumber = IDNumber;
    this.name = name;
    this.contact = contact;
    this.birthday = birthday;
    this.dayRegistered = dayRegistered;
    this.shortInformation = shortInformation;
    this.notices = notices;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public PersonT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      IDNumber = SQL.getLong(Column); Column++;
      name = new NameT(SQL, Column); Column += NameT.noOfSQLColumns();
      contact = new ContactT(SQL, Column); Column += ContactT.noOfSQLColumns();
      birthday = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      dayRegistered = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      shortInformation = SQL.getString(Column); Column++;
      notices = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 3 + NameT.noOfSQLColumns() + ContactT.noOfSQLColumns() + 2 * DateT.noOfSQLColumns();
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "IDNumber int, " +
           NameT.SQLCreateString(prefix) + ", " +
           ContactT.SQLCreateString(prefix) + ", " +
           DateT.SQLCreateString(prefix + "Birthday") + ", " +
           DateT.SQLCreateString(prefix + "DayRegistered") + ", " +
           prefix + "ShortInformation varchar(200), " +
           prefix + "Notices varchar(200), " +
           prefix + "CONSTRAINT PK_Person PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddString()
  {
    return getIDNumber() + ", " +
           getName().toSQLAddString() + ", " +
           getContact().toSQLAddString() + ", " +
           getDayRegistered().toSQLAddString() + ", " +
           getBirthday().toSQLAddString() + ", " +
           "'" + getShortInformation() + "', " +
           "'" + getNotices() + "'";
  }

  public String toSQLModifyString(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           getName().toSQLModifyString(prefix) + ", " +
           getContact().toSQLModifyString(prefix) + ", "+
           getBirthday().toSQLModifyString(prefix + "Birthday") + ", " +
           getDayRegistered().toSQLModifyString(prefix + "DayRegistered") + ", " +
           prefix + "ShortInformation = '" + getShortInformation() + "', " +
           prefix + "Notices = '" + getNotices() + "'";
  }

  public String toString()
  {
    return String.valueOf(name);
  }

  /**
   * Returns identification of a person.
   *
   * @return identification of a person.
   */

  public long getIDNumber()
  {
    return IDNumber;
  }

  /**
   * Returns name of a person.
   *
   * @return name of a person.
   */

  public NameT getName()
  {
    return name;
  }

  /**
   * Returns address of a person.
   *
   * @return address of a person.
   */

  public AddressT getAddress()
  {
    return contact.getAddress();
  }

  /**
   * Returns contact of a person.
   *
   * @return contact of a person.
   */

  public ContactT getContact()
  {
    return contact;
  }

  /**
   * Returns birthday of a person.
   *
   * @return birthday of a person.
   */

  public DateT getBirthday()
  {
    return birthday;
  }

  /**
   * Returns day registered of a person.
   *
   * @return day registered of a person.
   */

  public DateT getDayRegistered()
  {
    return dayRegistered;
  }

  /**
   * Returns short information of a person.
   *
   * @return short information of a person.
   */

  public String getShortInformation()
  {
    return shortInformation;
  }

  /**
   * Returns notices of a person.
   *
   * @return notices of a person.
   */

  public String getNotices()
  {
    return notices;
  }

  /**
   * Sets identification of a person.
   *
   * @param value new value.
   */

  public void setIDNumber(long value)
  {
    IDNumber = value;
  }

  /**
   * Sets name of a person.
   *
   * @param value new value.
   */

  public void setName(NameT value)
  {
    name = value;
  }

  /**
   * Sets address of a person.
   *
   * @param value new value.
   */

  public void setAddress(AddressT value)
  {
    contact.setAddress(value);
  }

  /**
   * Sets contact of a person.
   *
   * @param value new value.
   */

  public void setContact(ContactT value)
  {
    contact = value;
  }

  /**
   * Sets birthday of a person.
   *
   * @param value new value.
   */

  public void setBirthday(DateT value)
  {
    birthday = value;
  }

  /**
   * Sets day registered of a person.
   *
   * @param value new value.
   */

  public void setDayRegistered(DateT value)
  {
    dayRegistered = value;
  }

  /**
   * Sets short information of a person.
   *
   * @param value new value.
   */

  public void setShortInformation(String value)
  {
    shortInformation = value;
  }

  /**
   * Sets notices of a person.
   *
   * @param value new value.
   */

  public void setNotices(String value)
  {
    notices = value;
  }

  /**
   * Produces an address label.
   *
   * @return address label.
   */

  public String produceAdressLabel()
  {
    return getAddress().toString();
  }

  public Object getKey()
  {
    return new Long(getIDNumber());
  }

}
