
package semorg.person;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.ContactT;
import semorg.classes.DataBaseT;
import semorg.classes.DateT;
import semorg.classes.List;
import semorg.classes.NameT;
import semorg.seminar.CanConductListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class PersonListT extends List
{

  /**
   * The associated list.
   */

  private CanConductListT canConductList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public PersonListT(Connection DBConnection)
  {
    super(DBConnection);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public PersonListT(DataBaseT database)
  {
    super(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String personTableName = "Person";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String personTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           NameT.tableColumns(prefix) + ", " +
           ContactT.tableColumns(prefix) + ", " +
           DateT.tableColumns(prefix + "Birthday") + ", " +
           DateT.tableColumns(prefix + "DayRegistered") + ", " +
           prefix + "ShortInformation, " +
           prefix + "Notices";
  }

  public String toString()
  {
    return "List of " + count() + " persons";
  }

  public boolean create()
  {
    return create(personTableName, PersonT.SQLCreateString(""));
  }

  public boolean destroy()
  {
    return destroy(personTableName);
  }

  public boolean add(Ancestor element)
  {
    return add(personTableName, tableColumns(""), element.toSQLAddString());
  }

  public boolean remove(Object key)
  {
    return remove(personTableName, personTableKeyName, key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(personTableName, personTableKeyName, element.toSQLModifyString(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(personTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(personTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      PersonT person = new PersonT(Result, 1);
      database.close(Result);
      return person;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(personTableName, personTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        PersonT Person = new PersonT(Result, 1);
        database.close(Result);
        return Person;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

}
