
package semorg.person;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.ContactT;
import semorg.classes.DateT;
import semorg.classes.NameT;
import semorg.seminar.CanConductListT;

/**
 * Objects of this class are representing docents in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class DocentT extends PersonT
{

  /**
   * Holds information about the docent.
   */

  private String biography;

  /**
   * Holds information about the docent.
   */

  private float honorar;

  /**
   * The list of seminars that this docent can conduct.
   */

  private CanConductListT canConductList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public DocentT()
  {
    super();
    biography = "";
    honorar = 0.0f;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public DocentT(long IDNumber, NameT name, ContactT contact, DateT birthday, DateT dayRegistered, String shortInformation, String notices, String biography, float honorar)
  {
    super(IDNumber, name, contact, birthday, dayRegistered, shortInformation, notices);
    this.biography = biography;
    this.honorar = honorar;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public DocentT(ResultSet SQL, int Column)
  {
    biography = "";
    honorar = 0.0f;
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      biography = SQL.getString(Column); Column++;
      honorar = SQL.getFloat(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assigns all atributes from the given person.
   *
   * @param person object containing values to be assigned to atributes.
   */

  public void assignFromPerson(PersonT person)
  {
    if ((person != null) && (person.getIDNumber() == getIDNumber()))
    {
      setName(person.getName());
      setContact(person.getContact());
      setBirthday(person.getBirthday());
      setDayRegistered(person.getDayRegistered());
      setShortInformation(person.getShortInformation());
      setNotices(person.getNotices());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 3;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "Biography varchar(400), " +
           prefix + "Honorar float, " +
           prefix + "CONSTRAINT PK_Docent PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           "'" + getBiography() + "', " +
           getHonorar();
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "Biography = '" + getBiography() + "', " +
           prefix + "Honorar = " + getHonorar();
  }

  /**
   * Returns biagraphy of a docent.
   *
   * @return biography of a docent.
   */

  public String getBiography()
  {
    return biography;
  }

  /**
   * Returns honorar of a docent.
   *
   * @return honorar of a docent.
   */

  public float getHonorar()
  {
    return honorar;
  }

  /**
   * Sets biography of a docent.
   *
   * @param value new value.
   */

  public void setBiography(String value)
  {
    biography = value;
  }

  /**
   * Sets honorar of a docent.
   *
   * @param value new value.
   */

  public void setHonorar(float value)
  {
    honorar = value;
  }

  /**
   * Sets the link list for this booking.
   *
   * @param value the link list for this booking
   */

  public void setCanConductList(CanConductListT value)
  {
    this.canConductList = value;
  }

}
