
package semorg.person;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.seminar.CanConductListT;

/**
 * Instances of this class represent list of elements that are contained in the 
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */
 
public class DocentListT extends List
{

  /**
   * The associated list.
   */
   
  private PersonListT personList;

  /**
   * The associated list.
   */
   
  private CanConductListT canConductList;

  /**
   * Creates a new instance associated with the database with the given 
   * connection.
   *
   * @param DBConnection connection with the database.
   */
   
  public DocentListT(Connection DBConnection)
  {
    super(DBConnection);
    this.personList = new PersonListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */
   
  public DocentListT(DataBaseT database)
  {
    super(database);
    this.personList = new PersonListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */
   
  private final String docentTableName = "Docent";

  /**
   * The primary key name of the table in which are elements stored in the 
   * database.
   */
   
  private final String docentTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */
   
  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "Biography, " +
           prefix + "Honorar";
  }

  public String toString()
  {
    return "List of " + count() + " Docents";
  }

  public boolean create()
  {
    personList.create();
    return create(docentTableName, DocentT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(docentTableName);
  }

  public boolean add(Ancestor element)
  {
    return personList.add(element) &&
           add(docentTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return remove(docentTableName, docentTableKeyName, key) &&
           personList.remove(key) ;
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(docentTableName, docentTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = personList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(docentTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(docentTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      DocentT Docent = new DocentT(Result, 1);
      Docent.assignFromPerson( (PersonT) personList.find(Docent.getKey()));
      database.close(Result);
      Docent.setCanConductList(canConductList);
      return Docent;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(docentTableName, docentTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        DocentT Docent = new DocentT(Result, 1);
        Docent.assignFromPerson( (PersonT) personList.find(key));
        database.close(Result);
        Docent.setCanConductList(canConductList);
        return Docent;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */
   
  public void setCanConductList(CanConductListT value)
  {
    this.canConductList = value;
  }

}
