
package semorg.person;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.ContactT;
import semorg.classes.DateT;
import semorg.classes.NameT;
import semorg.company.CompanyListT;
import semorg.company.CompanyT;

/**
 * Objects of this class are representing clients in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class ClientT extends PersonT
{

  /**
   * Holds information about the client.
   */

  private String function;

  /**
   * Holds information about the client.
   */

  private float exchange;

  /**
   * Holds information about the client.
   */

  private String company;

  /**
   * The list of companies.
   */

  private CompanyListT companyList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public ClientT()
  {
    super();
    function = "";
    exchange = 0.0f;
    company = null;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public ClientT(long IDNumber, NameT name, ContactT contact,
                 DateT birthday, DateT dayRegistered,
                 String shortInformation, String notices,
                 String function, float exchange, String company)
  {
    super(IDNumber, name, contact, birthday, dayRegistered, shortInformation, notices);
    this.function = function;
    this.exchange = exchange;
    this.company = company;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public ClientT(ResultSet SQL, int Column)
  {
    function = "";
    exchange = 0.0f;
    company = "";
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      function = SQL.getString(Column); Column++;
      exchange = SQL.getFloat(Column); Column++;
      company = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assigns all atributes from the given person.
   *
   * @param person object containing values to be assigned to atributes.
   */

  public void assignFromPerson(PersonT person)
  {
    if ((person != null) && (person.getIDNumber() == getIDNumber()))
    {
      setName(person.getName());
      setContact(person.getContact());
      setBirthday(person.getBirthday());
      setDayRegistered(person.getDayRegistered());
      setShortInformation(person.getShortInformation());
      setNotices(person.getNotices());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 4;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "Function varchar(50), " +
           prefix + "Exchange float, " +
           prefix + "Company varchar(10), " +
           prefix + "CONSTRAINT PK_Client PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           "'" + getFunction() + "', " +
           "" + getExchange() + ", " +
           ((this.company != null) ? "'" + this.company.toString() + "'" : "NULL");
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "Function = '" + getFunction() + "', " +
           prefix + "Exchange = " + getExchange() + ", " +
           prefix + "Company = " + ((this.company != null) ? "'" + this.company.toString() + "'" : "NULL");
  }

  /**
   * Returns function of a client.
   *
   * @return function of a client.
   */

  public String getFunction()
  {
    return function;
  }

  /**
   * Returns exchange rate for a client.
   *
   * @return exchange rate for a client.
   */

  public float getExchange()
  {
    return exchange;
  }

  /**
   * Returns clients company.
   *
   * @return clients company.
   */

  public CompanyT getCompany()
  {
    if (companyList == null)
    {
      return null;
    }
    else if (company == null)
    {
      return null;
    }
    else
    {
      return (CompanyT) companyList.find(company);
    }
  }

  /**
   * Sets function of a client.
   *
   * @param value new value.
   */

  public void setFunction(String value)
  {
    function = value;
  }

  /**
   * Sets exchange rate for a client.
   *
   * @param value new value.
   */

  public void setExchange(float value)
  {
    exchange = value;
  }

  /**
   * Sets clients company.
   *
   * @param value new value.
   */

  public void setCompany(CompanyT value)
  {
    if (value != null)
    {
      company = value.getShortName();
    }
    else
    {
      company = null;
    }
  }

  /**
   * Sets clients company.
   *
   * @param value new value.
   */

  public void setCompany(String value)
  {
    company = value;
  }

  /**
   * Sets company list for this booking.
   *
   * @param value company list for this booking
   */

  public void setCompanyList(CompanyListT value)
  {
    this.companyList = value;
  }

  /**
   * Produces a notification.
   *
   * @return result of a notification.
   */

  public String produceNotification()
  {
    return "Client " + getName() + "notified";
  }
}
