
package semorg.person;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.company.CompanyListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class ClientListT extends List
{

  /**
   * The associated list.
   */

  private PersonListT personList;

  /**
   * The associated list.
   */

  private CompanyListT companyList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public ClientListT(Connection DBConnection)
  {
    super(DBConnection);
    this.personList = new PersonListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public ClientListT(DataBaseT database)
  {
    super(database);
    this.personList = new PersonListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String clientTableName = "Client";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String clientTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "Function, " +
           prefix + "Exchange, " +
           prefix + "Company";
  }

  public String toString()
  {
    return "List of " + count() + " Clients";
  }

  public boolean create()
  {
    personList.create();
    return create(clientTableName, ClientT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(clientTableName);
  }

  public boolean destroy(boolean all)
  {
    destroy(clientTableName);
    return destroy("Person");
  }

  public boolean add(Ancestor element)
  {
    return personList.add(element) &&
           add(clientTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return remove(clientTableName, clientTableKeyName, key) &&
           personList.remove(key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(clientTableName, clientTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = personList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(clientTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(clientTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      ClientT Client = new ClientT(Result, 1);
      Client.assignFromPerson( (PersonT) personList.find(Client.getKey()));
      database.close(Result);
      Client.setCompanyList(companyList);
      return Client;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(clientTableName, clientTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        ClientT Client = new ClientT(Result, 1);
        Client.assignFromPerson((PersonT) personList.find(key));
        database.close(Result);
        Client.setCompanyList(companyList);
        return Client;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setCompanyList(CompanyListT value)
  {
    this.companyList = value;
  }

  public CompanyListT getCompanyList()
  {
    return companyList;
  }

}
