
package semorg.person;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.ContactT;
import semorg.classes.DateT;
import semorg.classes.NameT;

/**
 * Objects of this class are representing associates in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class AssociateT extends PersonT
{

  /**
   * Holds information about the associate.
   */

  private String occupation;

  /**
   * Holds information about the associate.
   */

  private String entitlement;

  /**
   * Holds information about the associate.
   */

  private String password;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public AssociateT()
  {
    super();
    occupation = "";
    entitlement = "";
    password = "";
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public AssociateT(long IDNumber, NameT name, ContactT contact,
                    DateT birthday, DateT dayRegistered,
                    String shortInformation, String notices,
                    String occupation, String entitlement, String password)
  {
    super(IDNumber, name, contact, birthday, dayRegistered, shortInformation, notices);
    this.occupation = occupation;
    this.entitlement = entitlement;
    this.password = password;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public AssociateT(ResultSet SQL, int Column)
  {
    occupation = "";
    entitlement = "";
    password = "";
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      occupation = SQL.getString(Column); Column++;
      entitlement = SQL.getString(Column); Column++;
      password = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assigns all atributes from the given person.
   *
   * @param person object containing values to be assigned to atributes.
   */

  public void assignFromPerson(PersonT person)
  {
    if ((person != null) && (person.getIDNumber() == getIDNumber()))
    {
      setName(person.getName());
      setContact(person.getContact());
      setBirthday(person.getBirthday());
      setDayRegistered(person.getDayRegistered());
      setShortInformation(person.getShortInformation());
      setNotices(person.getNotices());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 4;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "Occupation varchar(30), " +
           prefix + "Entitlement varchar(20), " +
           prefix + "Password varchar(6), " +
           prefix + "CONSTRAINT PK_Associate PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           "'" + getOccupation() + "', " +
           "'" + getEntitlement() + "', " +
           "'" + getPassword() + "'";
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "Occupation = '" + getOccupation() + "', " +
           prefix + "Entitlement = '" + getEntitlement() + "', " +
           prefix + "Password = '" + getPassword() + "'";
  }

  /**
   * Returns occupation of an associate.
   *
   * @return occupation of an associate.
   */

  public String getOccupation()
  {
    return occupation;
  }

  /**
   * Returns entitlement of an associate.
   *
   * @return entitlement of an associate.
   */

  public String getEntitlement()
  {
    return entitlement;
  }

  /**
   * Returns password of an associate.
   *
   * @return password of an associate.
   */

  public String getPassword()
  {
    return password;
  }

  /**
   * Sets occupation of an associate.
   *
   * @param value new value.
   */

  public void setOccupation(String value)
  {
    occupation = value;
  }

  /**
   * Sets entitlement of an associate.
   *
   * @param value new value.
   */

  public void setEntitlement(String value)
  {
    entitlement = value;
  }

  /**
   * Sets password of an associate.
   *
   * @param value new value.
   */

  public void setPassword(String value)
  {
    password = value;
  }

}
