
package semorg.person;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;

/**
 * Instances of this class represent list of elements that are contained in the 
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */
 
public class AssociateListT extends List
{

  /**
   * The associated list.
   */
   
  private PersonListT personList;

  /**
   * Creates a new instance associated with the database with the given 
   * connection.
   *
   * @param DBConnection connection with the database.
   */
   
  public AssociateListT(Connection DBConnection)
  {
    super(DBConnection);
    this.personList = new PersonListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */
   
  public AssociateListT(DataBaseT database)
  {
    super(database);
    this.personList = new PersonListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */
   
  private final String associateTableName = "Associate";

  /**
   * The primary key name of the table in which are elements stored in the 
   * database.
   */
   
  private final String associateTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */
   
  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "Occupation, " +
           prefix + "Entitlement, " +
           prefix + "Password";
  }

  public String toString()
  {
    return "List of " + count() + " Associates";
  }

  public boolean create()
  {
    personList.create();
    return create(associateTableName, AssociateT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(associateTableName);
  }

  public boolean add(Ancestor element)
  {
    return personList.add(element) &&
           add(associateTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return personList.remove(key) &&
           remove(associateTableName, associateTableKeyName, key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(associateTableName, associateTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = personList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(associateTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(associateTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      AssociateT Associate = new AssociateT(Result, 1);
      Associate.assignFromPerson((PersonT)personList.find(Associate.getKey()));
      database.close(Result);
      return Associate;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(associateTableName, associateTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        AssociateT Associate = new AssociateT(Result, 1);
        Associate.assignFromPerson((PersonT) personList.find(key));
        database.close(Result);
        return Associate;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

}
