package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.seminar.SeminarT;

public class SeminarPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JPanel jPanel1 = new JPanel();
  JPanel jPanel2 = new JPanel();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JTextField jTextField6 = new JTextField();
  JTextField jTextField5 = new JTextField();
  JTextField jTextField4 = new JTextField();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  JTabbedPane jTabbedPane1 = new JTabbedPane();
  JTextArea jTextArea1 = new JTextArea();
  JTextArea jTextArea2 = new JTextArea();
  JTextArea jTextArea3 = new JTextArea();
  JTextArea jTextArea4 = new JTextArea();
  JTextArea jTextArea5 = new JTextArea();
  JTextArea jTextArea6 = new JTextArea();
  JTextArea jTextArea7 = new JTextArea();
  InputVerifier integerVerifier = new IntegerVerifier();
  InputVerifier floatVerifier = new FloatVerifier();
  Document IDDocument = new PlainDocument();
  Document titleDocument = new PlainDocument();
  Document duranceDocument = new PlainDocument();
  Document chargeDocument = new PlainDocument();
  Document maxDocument = new PlainDocument();
  Document minDocument = new PlainDocument();
  Document purposeDocument = new PlainDocument();
  Document methodicDocument = new PlainDocument();
  Document overviewDocument = new PlainDocument();
  Document procedureDocument = new PlainDocument();
  Document targetDocument = new PlainDocument();
  Document docDocument = new PlainDocument();
  Document preconditionsDocument = new PlainDocument();

  public SeminarPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jPanel1.setLayout(gridBagLayout2);
    jLabel1.setText("ID:");
    jLabel2.setText("Title:");
    jLabel3.setText("Durance:");
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(IDDocument);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setDocument(titleDocument);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField3.setInputVerifier(integerVerifier);
    jTextField3.setDocument(duranceDocument);
    jLabel6.setText("Minimum:");
    jLabel5.setText("Maximum:");
    jLabel4.setText("Charge:");
    jPanel2.setLayout(gridBagLayout3);
    jTextField4.setMinimumSize(new Dimension(120, 21));
    jTextField4.setPreferredSize(new Dimension(120, 21));
    jTextField4.setInputVerifier(floatVerifier);
    jTextField4.setDocument(chargeDocument);
    jTextField5.setMinimumSize(new Dimension(120, 21));
    jTextField5.setPreferredSize(new Dimension(120, 21));
    jTextField5.setInputVerifier(integerVerifier);
    jTextField5.setDocument(maxDocument);
    jTextField6.setMinimumSize(new Dimension(120, 21));
    jTextField6.setPreferredSize(new Dimension(120, 21));
    jTextField6.setInputVerifier(integerVerifier);
    jTextField6.setDocument(minDocument);
    jTextArea1.setMinimumSize(new Dimension(320, 48));
    jTextArea1.setPreferredSize(new Dimension(320, 48));
    jTextArea1.setDocument(purposeDocument);
    jTextArea2.setMinimumSize(new Dimension(320, 48));
    jTextArea2.setPreferredSize(new Dimension(320, 48));
    jTextArea2.setDocument(methodicDocument);
    jTextArea3.setMinimumSize(new Dimension(320, 48));
    jTextArea3.setPreferredSize(new Dimension(320, 48));
    jTextArea3.setDocument(overviewDocument);
    jTextArea4.setMinimumSize(new Dimension(320, 48));
    jTextArea4.setPreferredSize(new Dimension(320, 48));
    jTextArea4.setDocument(procedureDocument);
    jTextArea5.setMinimumSize(new Dimension(320, 48));
    jTextArea5.setPreferredSize(new Dimension(320, 48));
    jTextArea5.setDocument(targetDocument);
    jTextArea6.setMinimumSize(new Dimension(320, 48));
    jTextArea6.setPreferredSize(new Dimension(320, 48));
    jTextArea6.setDocument(docDocument);
    jTextArea7.setMinimumSize(new Dimension(320, 48));
    jTextArea7.setPreferredSize(new Dimension(320, 48));
    jTextArea7.setDocument(preconditionsDocument);
    IDDocument.addUndoableEditListener(new SeminarPanel_IDDocument_undoableEditAdapter(this));
    titleDocument.addUndoableEditListener(new SeminarPanel_titleDocument_undoableEditAdapter(this));
    duranceDocument.addUndoableEditListener(new SeminarPanel_duranceDocument_undoableEditAdapter(this));
    chargeDocument.addUndoableEditListener(new SeminarPanel_chargeDocument_undoableEditAdapter(this));
    maxDocument.addUndoableEditListener(new SeminarPanel_maxDocument_undoableEditAdapter(this));
    minDocument.addUndoableEditListener(new SeminarPanel_minDocument_undoableEditAdapter(this));
    purposeDocument.addUndoableEditListener(new SeminarPanel_purposeDocument_undoableEditAdapter(this));
    methodicDocument.addUndoableEditListener(new SeminarPanel_methodicDocument_undoableEditAdapter(this));
    overviewDocument.addUndoableEditListener(new SeminarPanel_overviewDocument_undoableEditAdapter(this));
    procedureDocument.addUndoableEditListener(new SeminarPanel_procedureDocument_undoableEditAdapter(this));
    targetDocument.addUndoableEditListener(new SeminarPanel_targetDocument_undoableEditAdapter(this));
    docDocument.addUndoableEditListener(new SeminarPanel_docDocument_undoableEditAdapter(this));
    preconditionsDocument.addUndoableEditListener(new SeminarPanel_preconditionsDocument_undoableEditAdapter(this));
    this.add(jPanel1,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 16), 0, 0));
    jPanel1.add(jTextField1,       new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField2,      new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField3,     new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jLabel1,    new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel2,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel3,  new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jPanel2,   new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel2.add(jTextField4,    new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel2.add(jTextField5,   new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel2.add(jTextField6,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel2.add(jLabel4,   new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel2.add(jLabel5,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel2.add(jLabel6,   new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jTabbedPane1,    new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(8, 0, 0, 0), 0, 0));
    jTabbedPane1.add(jTextArea1,   "Purpose");
    jTabbedPane1.add(jTextArea2,   "Methodic");
    jTabbedPane1.add(jTextArea3,   "Overview");
    jTabbedPane1.add(jTextArea4,   "Daily procedure");
    jTabbedPane1.add(jTextArea5,   "Target group");
    jTabbedPane1.add(jTextArea6,   "Documentation");
    jTabbedPane1.add(jTextArea7,   "Preconditions");
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new SeminarT();
    }
    super.setElement(value);
    SeminarT seminar = (SeminarT) value;
    jTextField1.setText(seminar.getShortName());
    jTextField2.setText(seminar.getTitle());
    jTextField3.setText(String.valueOf(seminar.getDurance()));
    jTextField4.setText(String.valueOf(seminar.getCharge()));
    jTextField5.setText(String.valueOf(seminar.getParticipiantMax()));
    jTextField6.setText(String.valueOf(seminar.getParticipiantMin()));
    jTextArea1.setText(seminar.getPurpose());
    jTextArea2.setText(seminar.getMethodic());
    jTextArea3.setText(seminar.getOverview());
    jTextArea4.setText(seminar.getDailyProcedure());
    jTextArea5.setText(seminar.getTargetGroup());
    jTextArea6.setText(seminar.getDocumentation());
    jTextArea7.setText(seminar.getPreconditions());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(mode == AncestorDialog.ADD_MODE);
    jTextField2.setEditable(editable);
    jTextField3.setEditable(editable);
    jTextField4.setEditable(editable);
    jTextField5.setEditable(editable);
    jTextField6.setEditable(editable);
    jTextArea1.setEditable(editable);
    jTextArea2.setEditable(editable);
    jTextArea3.setEditable(editable);
    jTextArea4.setEditable(editable);
    jTextArea5.setEditable(editable);
    jTextArea6.setEditable(editable);
  }

  void IDDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setShortName(jTextField1.getText());
  }

  void titleDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setTitle(jTextField2.getText());
  }

  void duranceDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    try
    {
      seminar.setDurance(Integer.parseInt(jTextField3.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void chargeDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    try
    {
      seminar.setCharge(Float.parseFloat(jTextField4.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void maxDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    try
    {
      seminar.setParticipiantMax(Integer.parseInt(jTextField5.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void minDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    try
    {
      seminar.setParticipiantMin(Integer.parseInt(jTextField6.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void purposeDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setPurpose(jTextArea1.getText());
  }

  void methodicDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setMethodic(jTextArea2.getText());
  }

  void overviewDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setOverview(jTextArea3.getText());
  }

  void procedureDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setDailyProcedure(jTextArea4.getText());
  }

  void targetDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setTargetGroup(jTextArea5.getText());
  }

  void docDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setDocumentation(jTextArea6.getText());
  }

  void preconditionsDocument_undoableEditHappened(UndoableEditEvent e)
  {
    SeminarT seminar = (SeminarT) element;
    seminar.setPreconditions(jTextArea7.getText());
  }

}

class SeminarPanel_IDDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_IDDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.IDDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_titleDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_titleDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.titleDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_duranceDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_duranceDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.duranceDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_chargeDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_chargeDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.chargeDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_maxDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_maxDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.maxDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_minDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_minDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.minDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_purposeDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_purposeDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.purposeDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_methodicDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_methodicDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.methodicDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_overviewDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_overviewDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.overviewDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_procedureDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_procedureDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.procedureDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_targetDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_targetDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.targetDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_docDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_docDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.docDocument_undoableEditHappened(e);
  }
}

class SeminarPanel_preconditionsDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  SeminarPanel adaptee;

  SeminarPanel_preconditionsDocument_undoableEditAdapter(SeminarPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.preconditionsDocument_undoableEditHappened(e);
  }
}
