package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Date;

import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.classes.DateT;
import semorg.classes.TimeT;
import semorg.presentation.PresentationListT;
import semorg.presentation.PresentationT;
import semorg.seminar.SeminarT;

import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.event.DateSelectionEvent;

public class PresentationPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JPanel jPanel1 = new JPanel();
  JPanel jPanel2 = new JPanel();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JDatePicker jTextField3 = new JDatePicker();
  JDatePicker jTextField4 = new JDatePicker();
  JTextField jTextField5 = new JTextField();
  JTextField jTextField6 = new JTextField();
  JTextField jTextField7 = new JTextField();
  JTextField jTextField8 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();
  JLabel jLabel8 = new JLabel();
  JTextField jTextField9 = new JTextField();
  JLabel jLabel9 = new JLabel();
  AddressPanel jPanel3 = new AddressPanel();
  JPanel jPanel4 = new JPanel();
  JTextField jTextField10 = new JTextField();
  JComboBox jComboBox1 = new JComboBox();
  JLabel jLabel10 = new JLabel();
  JLabel jLabel11 = new JLabel();
  JLabel jLabel12 = new JLabel();
  JLabel jLabel13 = new JLabel();
  InputVerifier timeVerifier = new TimeVerifier();
  InputVerifier integerVerifier = new IntegerVerifier();
  Document IDDocument = new PlainDocument();
  Document duranceDocument = new PlainDocument();
  Document startDocument = new PlainDocument();
  Document endDocument = new PlainDocument();
  Document firstDocument = new PlainDocument();
  Document lastDocument = new PlainDocument();
  Document placeDocument = new PlainDocument();
  Document maxDocument = new PlainDocument();

  public PresentationPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jPanel1.setLayout(gridBagLayout2);
    jPanel2.setLayout(gridBagLayout3);
    jTextField7.setMinimumSize(new Dimension(120, 21));
    jTextField7.setPreferredSize(new Dimension(120, 21));
    jTextField7.setInputVerifier(timeVerifier);
    jTextField7.setDocument(firstDocument);
    jLabel1.setText("ID:");
    jTextField8.setMinimumSize(new Dimension(120, 21));
    jTextField8.setPreferredSize(new Dimension(120, 21));
    jTextField8.setInputVerifier(timeVerifier);
    jTextField8.setDocument(lastDocument);
    jTextField6.setMinimumSize(new Dimension(120, 21));
    jTextField6.setPreferredSize(new Dimension(120, 21));
    jTextField6.setInputVerifier(timeVerifier);
    jTextField6.setDocument(endDocument);
    jTextField5.setMinimumSize(new Dimension(120, 21));
    jTextField5.setPreferredSize(new Dimension(120, 21));
    jTextField5.setInputVerifier(timeVerifier);
    jTextField5.setDocument(startDocument);
    jTextField4.setMinimumSize(new Dimension(120, 21));
    jTextField4.setPreferredSize(new Dimension(120, 21));
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setInputVerifier(integerVerifier);
    jTextField2.setDocument(duranceDocument);
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setInputVerifier(integerVerifier);
    jTextField1.setDocument(IDDocument);
    jLabel2.setText("Durance:");
    jLabel3.setText("First day:");
    jLabel4.setText("Last day:");
    jLabel5.setText("Start time:");
    jLabel6.setText("End time:");
    jLabel7.setText("First day start:");
    jLabel8.setText("Last day end:");
    jLabel9.setText("Place:");
    jTextField9.setMinimumSize(new Dimension(120, 21));
    jTextField9.setPreferredSize(new Dimension(120, 21));
    jTextField9.setDocument(placeDocument);
    jLabel10.setText("Maximum:");
    jLabel11.setText("Canceled:");
    jTextField10.setMinimumSize(new Dimension(120, 21));
    jTextField10.setPreferredSize(new Dimension(120, 21));
    jTextField10.setInputVerifier(integerVerifier);
    jTextField10.setDocument(maxDocument);
    jComboBox1.setMinimumSize(new Dimension(120, 21));
    jComboBox1.setPreferredSize(new Dimension(120, 21));
    String [] a = new String[2]; a[0] = "Yes"; a[1] = "No";
    jComboBox1.setModel(new DefaultComboBoxModel(a));
    jLabel12.setText("Seminar:");
    jLabel13.setMinimumSize(new Dimension(120, 17));
    jLabel13.setPreferredSize(new Dimension(120, 17));
    jLabel13.addMouseListener(new PresentationPanel_jLabel13_mouseAdapter(this));
    IDDocument.addUndoableEditListener(new PresentationPanel_IDDocument_undoableEditAdapter(this));
    duranceDocument.addUndoableEditListener(new PresentationPanel_duranceDocument_undoableEditAdapter(this));
    jTextField3.addDateSelectionListener(new PresentationPanel_fromDocument_dateSelectionAdapter(this));
    jTextField4.addDateSelectionListener(new PresentationPanel_toDocument_dateSelectionAdapter(this));
    startDocument.addUndoableEditListener(new PresentationPanel_startDocument_undoableEditAdapter(this));
    endDocument.addUndoableEditListener(new PresentationPanel_endDocument_undoableEditAdapter(this));
    firstDocument.addUndoableEditListener(new PresentationPanel_firstDocument_undoableEditAdapter(this));
    lastDocument.addUndoableEditListener(new PresentationPanel_lastDocument_undoableEditAdapter(this));
    placeDocument.addUndoableEditListener(new PresentationPanel_placeDocument_undoableEditAdapter(this));
    maxDocument.addUndoableEditListener(new PresentationPanel_maxDocument_undoableEditAdapter(this));
    this.add(jPanel1,                new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 8, 16), 0, 0));
    jPanel1.add(jTextField1,           new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 18, 2), 0, 0));
    jPanel1.add(jTextField2,         new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField3,        new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField4,       new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField5,      new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField6,     new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField7,    new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField8,   new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jLabel1,   new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 18, 4), 0, 0));
    jPanel1.add(jLabel2,  new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel3,   new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel4,  new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel5,  new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel6,  new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel7,  new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel8,  new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jPanel2,                new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 8, 0), 0, 0));
    jPanel2.add(jTextField9,                     new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel2.add(jLabel9,                    new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 2, 4), 0, 0));
    jPanel2.add(jPanel3,                  new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel2.add(jPanel4,                   new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 8), 0, 0));
    jPanel2.add(jTextField10,      new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel2.add(jComboBox1,      new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel2.add(jLabel10,    new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel2.add(jLabel11,  new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel12,      new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel13,      new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new PresentationT();
    }
    super.setElement(value);
    PresentationT presentation = (PresentationT) value;
    jTextField1.setText(String.valueOf(presentation.getIDNumber()));
    jTextField2.setText(String.valueOf(presentation.getDurance()));
    jTextField3.setSelectedDate(presentation.getFrom().toDate());
    jTextField4.setSelectedDate(presentation.getTo().toDate());
    if (presentation.getDailyStart() != null)
    {
      jTextField5.setText(presentation.getDailyStart().toString());
    }
    else
    {
      jTextField5.setText("unknown");
    }
    if (presentation.getDailyEnd() != null)
    {
      jTextField6.setText(presentation.getDailyEnd().toString());
    }
    else
    {
      jTextField6.setText("unknown");
    }
    if (presentation.getStartFirstDay() != null)
    {
      jTextField7.setText(presentation.getStartFirstDay().toString());
    }
    else
    {
      jTextField7.setText("unknown");
    }
    if (presentation.getEndLastDay() != null)
    {
      jTextField8.setText(presentation.getEndLastDay().toString());
    }
    else
    {
      jTextField8.setText("unknown");
    }
    jTextField9.setText(presentation.getPlace());
    jTextField10.setText(String.valueOf(presentation.getParticipiantMax()));
    if (presentation.getCanceled())
    {
      jComboBox1.setSelectedItem("Yes");
    }
    else
    {
      jComboBox1.setSelectedItem("No");
    }
    jPanel3.setElement(presentation.getAddress());
    if (presentation.getSeminar() != null)
    {
      jLabel13.setText(presentation.getSeminar().toString());
    }
    else
    {
      jLabel13.setText("none");
    }
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(mode == AncestorDialog.ADD_MODE);
    jTextField2.setEditable(editable);
    jTextField3.setEnabled(editable);
    jTextField4.setEnabled(editable);
    jTextField5.setEditable(editable);
    jTextField6.setEditable(editable);
    jTextField7.setEditable(editable);
    jTextField8.setEditable(editable);
    jTextField9.setEditable(editable);
    jTextField10.setEditable(editable);
    jComboBox1.setEditable(editable);
    jPanel3.setMode(mode);
  }

  void IDDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    try
    {
      presentation.setIDNumber(Integer.parseInt(jTextField1.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void duranceDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    try
    {
      presentation.setDurance(Integer.parseInt(jTextField2.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void fromDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    Date d = jTextField3.getSelectedDate();
    presentation.setFrom(new DateT(d));
  }

  void toDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    Date d = jTextField4.getSelectedDate();
    presentation.setTo(new DateT(d));
  }

  void startDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    TimeT t;
    try
    {
      t = TimeT.valueOf(jTextField5.getText());
    }
    catch(IllegalArgumentException ex)
    {
      t = null;
    }
    presentation.setDailyStart(t);
  }

  void endDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    TimeT t;
    try
    {
      t = TimeT.valueOf(jTextField6.getText());
    }
    catch(IllegalArgumentException ex)
    {
      t = null;
    }
    presentation.setDailyEnd(t);
  }

  void firstDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    TimeT t;
    try
    {
      t = TimeT.valueOf(jTextField7.getText());
    }
    catch(IllegalArgumentException ex)
    {
      t = null;
    }
    presentation.setStartFirstDay(t);
  }

  void lastDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    TimeT t;
    try
    {
      t = TimeT.valueOf(jTextField8.getText());
    }
    catch(IllegalArgumentException ex)
    {
      t = null;
    }
    presentation.setEndLastDay(t);
  }

  void placeDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    presentation.setPlace(jTextField9.getText());
  }

  void maxDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PresentationT presentation = (PresentationT) element;
    try
    {
      presentation.setParticipiantMax(Integer.parseInt(jTextField10.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void jLabel13_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      PresentationListT myList = (PresentationListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Seminar", true);
      dialog.setList(myList.getSeminarList());
      dialog.setPanel(new SeminarPanel());
      PresentationT presentation = (PresentationT) element;
      SeminarT seminar = presentation.getSeminar();
      if (seminar != null)
      {
        dialog.show(false, seminar.getShortName());
      }
      else
      {
        dialog.show(false);
      }
      presentation.setSeminar((SeminarT)dialog.getSelected());
      if (presentation.getSeminar() != null)
      {
        jLabel13.setText(presentation.getSeminar().toString());
      }
      else
      {
        jLabel13.setText("none");
      }
    }
  }

}

class PresentationPanel_IDDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_IDDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.IDDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_duranceDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_duranceDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.duranceDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_fromDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  PresentationPanel adaptee;

  PresentationPanel_fromDocument_dateSelectionAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.fromDocument_dateSelectionHappened(e);
  }
}

class PresentationPanel_toDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  PresentationPanel adaptee;

  PresentationPanel_toDocument_dateSelectionAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.toDocument_dateSelectionHappened(e);
  }
}

class PresentationPanel_startDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_startDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.startDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_endDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_endDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.endDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_firstDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_firstDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.firstDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_lastDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_lastDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.lastDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_placeDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_placeDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.placeDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_maxDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PresentationPanel adaptee;

  PresentationPanel_maxDocument_undoableEditAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.maxDocument_undoableEditHappened(e);
  }
}

class PresentationPanel_jLabel13_mouseAdapter extends java.awt.event.MouseAdapter
{
  PresentationPanel adaptee;

  PresentationPanel_jLabel13_mouseAdapter(PresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel13_mouseClicked(e);
  }
}