package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;

import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.classes.DateT;
import semorg.person.PersonT;

import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.event.DateSelectionEvent;

public class PersonPanel extends AncestorPanel
{

  GridBagLayout gridBagLayout1 = new GridBagLayout();
  ContactPanel jPanel2 = new ContactPanel();
  JTabbedPane jTabbedPane1 = new JTabbedPane();
  JPanel jPanel1 = new JPanel();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  NamePanel jPanel4 = new NamePanel();
  JDatePicker jTextField3 = new JDatePicker();
  JDatePicker jTextField2 = new JDatePicker();
  JTextField jTextField1 = new JTextField();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel1 = new JLabel();
  JTextArea jTextArea1 = new JTextArea();
  JTextArea jTextArea2 = new JTextArea();
  InputVerifier integerVerifier = new IntegerVerifier();
  Document IDDocument = new PlainDocument();
  Document infoDocument = new PlainDocument();
  Document noticesDocument = new PlainDocument();

  public PersonPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jPanel1.setLayout(gridBagLayout2);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setInputVerifier(integerVerifier);
    jTextField1.setDocument(IDDocument);
    jLabel3.setText("Registered:");
    jLabel2.setText("Birthday:");
    jLabel1.setText("ID:");
    jTextArea1.setMinimumSize(new Dimension(320, 48));
    jTextArea1.setPreferredSize(new Dimension(320, 48));
    jTextArea1.setDocument(infoDocument);
    jTextArea2.setMinimumSize(new Dimension(320, 48));
    jTextArea2.setPreferredSize(new Dimension(320, 48));
    jTextArea2.setDocument(noticesDocument);
    IDDocument.addUndoableEditListener(new PersonPanel_IDDocument_undoableEditAdapter(this));
    jTextField2.addDateSelectionListener(new PersonPanel_birthdayDocument_dateSelectionAdapter(this));
    jTextField3.addDateSelectionListener(new PersonPanel_registeredDocument_dateSelectionAdapter(this));
    infoDocument.addUndoableEditListener(new PersonPanel_infoDocument_undoableEditAdapter(this));
    noticesDocument.addUndoableEditListener(new PersonPanel_noticesDocument_undoableEditAdapter(this));
    this.add(jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    this.add(jTabbedPane1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    jTabbedPane1.add(jTextArea1, "Short information");
    jTabbedPane1.add(jTextArea2, "Notices");
    this.add(jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 16), 0, 0));
    jPanel1.add(jPanel4,   new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(12, 0, 0, 0), 0, 0));
    jPanel1.add(jTextField3,   new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField2,   new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    jPanel1.add(jTextField1,   new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(18, 2, 18, 2), 0, 0));
    jPanel1.add(jLabel3,   new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    jPanel1.add(jLabel1,    new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(18, 0, 18, 4), 0, 0));
    jPanel1.add(jLabel2,   new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new PersonT();
    }
    super.setElement(value);
    PersonT person = (PersonT) value;
    jTextField1.setText(String.valueOf(person.getIDNumber()));
    jTextField2.setSelectedDate(person.getBirthday().toDate());
    jTextField3.setSelectedDate(person.getDayRegistered().toDate());
    jTextArea1.setText(person.getShortInformation());
    jTextArea2.setText(person.getNotices());
    jPanel4.setElement(person.getName());
    jPanel2.setElement(person.getContact());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(mode == AncestorDialog.ADD_MODE);
    jTextField2.setEnabled(editable);
    jTextField3.setEnabled(editable);
    jTextArea1.setEditable(editable);
    jTextArea2.setEditable(editable);
    jPanel4.setMode(mode);
    jPanel2.setMode(mode);
  }

  void IDDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PersonT person = (PersonT) element;
    try
    {
      person.setIDNumber(Integer.parseInt(jTextField1.getText()));
    }
    catch(NumberFormatException ex)
    {
    }
  }

  void birthdayDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    PersonT person = (PersonT) element;
    Date d = jTextField2.getSelectedDate();
    person.setBirthday(new DateT(d));    
  }

  void registeredDocument_dateSelectionHappened(DateSelectionEvent e)
  {
  	PersonT person = (PersonT) element;
  	Date d = jTextField3.getSelectedDate();
    person.setDayRegistered(new DateT(d));
  }

  void infoDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PersonT person = (PersonT) element;
    person.setShortInformation(jTextArea1.getText());
  }

  void noticesDocument_undoableEditHappened(UndoableEditEvent e)
  {
    PersonT person = (PersonT) element;
    person.setNotices(jTextArea2.getText());
  }

}

class PersonPanel_IDDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PersonPanel adaptee;

  PersonPanel_IDDocument_undoableEditAdapter(PersonPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.IDDocument_undoableEditHappened(e);
  }
}

class PersonPanel_birthdayDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  PersonPanel adaptee;

  PersonPanel_birthdayDocument_dateSelectionAdapter(PersonPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.birthdayDocument_dateSelectionHappened(e);
  }
}

class PersonPanel_registeredDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  PersonPanel adaptee;

  PersonPanel_registeredDocument_dateSelectionAdapter(PersonPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.registeredDocument_dateSelectionHappened(e);
  }
}

class PersonPanel_infoDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PersonPanel adaptee;

  PersonPanel_infoDocument_undoableEditAdapter(PersonPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.infoDocument_undoableEditHappened(e);
  }
}

class PersonPanel_noticesDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  PersonPanel adaptee;

  PersonPanel_noticesDocument_undoableEditAdapter(PersonPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.noticesDocument_undoableEditHappened(e);
  }
}