package semorg.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.classes.NameT;

public class NamePanel extends AncestorPanel
{

  TitledBorder titledBorder1;
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  Document firstDocument = new PlainDocument();
  Document middleDocument = new PlainDocument();
  Document lastDocument = new PlainDocument();

  public NamePanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),"Name");
    this.setBorder(titledBorder1);
    this.setLayout(gridBagLayout1);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField3.setDocument(lastDocument);
    jLabel1.setText("First:");
    jLabel2.setText("Middle:");
    jLabel3.setText("Last:");
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setDocument(middleDocument);
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(firstDocument);
    firstDocument.addUndoableEditListener(new NamePanel_firstDocument_undoableEditAdapter(this));
    middleDocument.addUndoableEditListener(new NamePanel_middleDocument_undoableEditAdapter(this));
    lastDocument.addUndoableEditListener(new NamePanel_lastDocument_undoableEditAdapter(this));
    this.add(jTextField1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new NameT();
    }
    super.setElement(value);
    NameT name = (NameT) value;
    jTextField1.setText(name.getFirst());
    jTextField2.setText(name.getMiddle());
    jTextField3.setText(name.getLast());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextField2.setEditable(editable);
    jTextField3.setEditable(editable);
  }

  void firstDocument_undoableEditHappened(UndoableEditEvent e)
  {
    NameT name = (NameT) element;
    name.setFirst(jTextField1.getText());
  }

  void middleDocument_undoableEditHappened(UndoableEditEvent e)
  {
    NameT name = (NameT) element;
    name.setMiddle(jTextField2.getText());
  }

  void lastDocument_undoableEditHappened(UndoableEditEvent e)
  {
    NameT name = (NameT) element;
    name.setLast(jTextField3.getText());
  }

}

class NamePanel_firstDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  NamePanel adaptee;

  NamePanel_firstDocument_undoableEditAdapter(NamePanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.firstDocument_undoableEditHappened(e);
  }
}

class NamePanel_middleDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  NamePanel adaptee;

  NamePanel_middleDocument_undoableEditAdapter(NamePanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.middleDocument_undoableEditHappened(e);
  }
}

class NamePanel_lastDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  NamePanel adaptee;

  NamePanel_lastDocument_undoableEditAdapter(NamePanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.lastDocument_undoableEditHappened(e);
  }
}
