package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.person.DocentT;

public class DocentPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  PersonPanel jPanel1 = new PersonPanel();
  JTextArea jTextArea1 = new JTextArea();
  InputVerifier floatVerifier = new FloatVerifier();
  Document honorarDocument = new PlainDocument();
  Document biographytDocument = new PlainDocument();

  public DocentPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jLabel1.setText("Daily honorar:");
    jLabel2.setText("Bigraphy:");
    jTextArea1.setBorder(BorderFactory.createLoweredBevelBorder());
    jTextArea1.setMinimumSize(new Dimension(240, 48));
    jTextArea1.setPreferredSize(new Dimension(240, 48));
    jTextArea1.setDocument(biographytDocument);
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setInputVerifier(floatVerifier);
    jTextField1.setDocument(honorarDocument);
    honorarDocument.addUndoableEditListener(new DocentPanel_honorarDocument_undoableEditAdapter(this));
    biographytDocument.addUndoableEditListener(new DocentPanel_biographytDocument_undoableEditAdapter(this));
   
    this.add(jTextField1,     new GridBagConstraints(1,2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    
    this.add(jLabel1,     new GridBagConstraints(1,1 , 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    
    this.add(jLabel2,     new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(10, 16, 2, 4), 0, 0));
    
    this.add(jPanel1,   new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
       /*ovo je ono debelo*/
    this.add(jTextArea1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(10, 2, 2, 2), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new DocentT();
    }
    super.setElement(value);
    DocentT docent = (DocentT) value;
    jPanel1.setElement(docent);
    jTextField1.setText(String.valueOf(docent.getHonorar()));
    jTextArea1.setText(docent.getBiography());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextArea1.setEditable(editable);
    jPanel1.setMode(mode);
  }

  void honorarDocument_undoableEditHappened(UndoableEditEvent e)
  {
    DocentT docent = (DocentT) element;
    try
    {
      float f = Float.parseFloat(jTextArea1.getText());
      docent.setHonorar(f);
    }
    catch(IllegalArgumentException ex)
    {
    }
  }

  void biographytDocument_undoableEditHappened(UndoableEditEvent e)
  {
    DocentT docent = (DocentT) element;
    docent.setBiography(jTextArea1.getText());
  }

}

class DocentPanel_honorarDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  DocentPanel adaptee;

  DocentPanel_honorarDocument_undoableEditAdapter(DocentPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.honorarDocument_undoableEditHappened(e);
  }
}

class DocentPanel_biographytDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  DocentPanel adaptee;

  DocentPanel_biographytDocument_undoableEditAdapter(DocentPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.biographytDocument_undoableEditHappened(e);
  }
}
