package semorg.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.InputMethodEvent;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.classes.ContactT;

public class ContactPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JComboBox jComboBox1 = new JComboBox();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  AddressPanel jPanel1 = new AddressPanel();
  TitledBorder titledBorder1;
  JPanel jPanel2 = new JPanel();
  Document emailDocument = new PlainDocument();
  Document phoneDocument = new PlainDocument();
  Document faxDocument = new PlainDocument();

  public ContactPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),"Contact");
    this.setLayout(gridBagLayout1);
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(emailDocument);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setDocument(phoneDocument);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField3.setDocument(faxDocument);
    jLabel1.setText("Default:");
    jLabel2.setText("e-mail:");
    jLabel3.setText("Phone:");
    jLabel4.setText("Fax:");
    jComboBox1.setMinimumSize(new Dimension(120, 21));
    jComboBox1.setPreferredSize(new Dimension(120, 21));
    jComboBox1.setModel(new DefaultComboBoxModel(ContactT.options()));
    jComboBox1.addInputMethodListener(new ContactPanel_jComboBox1_inputMethodAdapter(this));
    this.setBorder(titledBorder1);
    emailDocument.addUndoableEditListener(new ContactPanel_emailDocument_undoableEditAdapter(this));
    phoneDocument.addUndoableEditListener(new ContactPanel_phoneDocument_undoableEditAdapter(this));
    faxDocument.addUndoableEditListener(new ContactPanel_faxDocument_undoableEditAdapter(this));
    this.add(jComboBox1,       new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField1,        new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField2,        new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField3,        new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel1,       new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel2,       new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3,       new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel4,       new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jPanel1,                   new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    this.add(jPanel2,    new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new ContactT();
    }
    super.setElement(value);
    ContactT contact = (ContactT) value;
    jComboBox1.setSelectedItem(contact.getDefault());
    jTextField1.setText(contact.getEMail());
    jTextField2.setText(contact.getPhone());
    jTextField3.setText(contact.getFax());
    jPanel1.setElement(contact.getAddress());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextField2.setEditable(editable);
    jTextField3.setEditable(editable);
    jComboBox1.setEnabled(editable);
    jPanel1.setMode(mode);
  }

  void jComboBox1_inputMethodTextChanged(InputMethodEvent e)
  {
    ContactT contact = (ContactT) element;
    contact.setDefault(jComboBox1.getSelectedItem().toString());
  }

  void emailDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ContactT contact = (ContactT) element;
    contact.setEMail(jTextField1.getText());
  }

  void phoneDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ContactT contact = (ContactT) element;
    contact.setPhone(jTextField2.getText());
  }

  void faxDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ContactT contact = (ContactT) element;
    contact.setFax(jTextField3.getText());
  }

}

class ContactPanel_jComboBox1_inputMethodAdapter implements java.awt.event.InputMethodListener
{
  ContactPanel adaptee;

  ContactPanel_jComboBox1_inputMethodAdapter(ContactPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void inputMethodTextChanged(InputMethodEvent e)
  {
    adaptee.jComboBox1_inputMethodTextChanged(e);
  }
  public void caretPositionChanged(InputMethodEvent e)
  {
  }
}

class ContactPanel_emailDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ContactPanel adaptee;

  ContactPanel_emailDocument_undoableEditAdapter(ContactPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.emailDocument_undoableEditHappened(e);
  }
}

class ContactPanel_phoneDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ContactPanel adaptee;

  ContactPanel_phoneDocument_undoableEditAdapter(ContactPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.phoneDocument_undoableEditHappened(e);
  }
}

class ContactPanel_faxDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ContactPanel adaptee;

  ContactPanel_faxDocument_undoableEditAdapter(ContactPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.faxDocument_undoableEditHappened(e);
  }
}