package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.presentation.CompanyPresentationT;

public class CompanyPresentationPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JLabel jLabel1 = new JLabel();
  PresentationPanel jPanel1 = new PresentationPanel();
  InputVerifier floatVerifier = new FloatVerifier();
  Document priceDocument = new PlainDocument();

  public CompanyPresentationPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jLabel1.setText("GlobalPrice:");
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setInputVerifier(floatVerifier);
    jTextField1.setDocument(priceDocument);
    priceDocument.addUndoableEditListener(new CompanyPresentationPanel_priceDocument_undoableEditAdapter(this));
    this.add(jTextField1,    new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jLabel1,    new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    this.add(jPanel1,   new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new CompanyPresentationT();
    }
    super.setElement(value);
    CompanyPresentationT presentation = (CompanyPresentationT) value;
    jTextField1.setText(String.valueOf(presentation.getGlobalPrice()));
    jPanel1.setElement(presentation);
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jPanel1.setMode(mode);
  }

  void priceDocument_undoableEditHappened(UndoableEditEvent e)
  {
    CompanyPresentationT presentation = (CompanyPresentationT) element;
    try
    {
      presentation.setGlobalPrice(Float.parseFloat(jTextField1.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

}

class CompanyPresentationPanel_priceDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  CompanyPresentationPanel adaptee;

  CompanyPresentationPanel_priceDocument_undoableEditAdapter(CompanyPresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.priceDocument_undoableEditHappened(e);
  }
}
