package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Date;

import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.classes.DateT;
import semorg.company.CompanyListT;
import semorg.company.CompanyT;
import semorg.person.ClientT;

import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.event.DateSelectionEvent;

public class CompanyPanel extends AncestorPanel
{
	
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	ContactPanel jPanel1 = new ContactPanel();
	JTabbedPane jTabbedPane1 = new JTabbedPane();
	JTextArea jTextArea1 = new JTextArea();
	JTextArea jTextArea2 = new JTextArea();
	JPanel jPanel2 = new JPanel();
	GridBagLayout gridBagLayout2 = new GridBagLayout();
	JTextField jTextField1 = new JTextField();
	JTextField jTextField2 = new JTextField();
	JTextField jTextField3 = new JTextField();
	JTextField jTextField4 = new JTextField();
	JTextField jTextField5 = new JTextField();
	JDatePicker jTextField6 = new JDatePicker();
	JLabel jLabel1 = new JLabel();
	JLabel jLabel2 = new JLabel();
	JLabel jLabel3 = new JLabel();
	JLabel jLabel4 = new JLabel();
	JLabel jLabel5 = new JLabel();
	JLabel jLabel6 = new JLabel();
	JLabel jLabel7 = new JLabel();
	JLabel jLabel8 = new JLabel();
	InputVerifier floatVerifier = new FloatVerifier();
	Document IDDocument = new PlainDocument();
	Document nameDocument = new PlainDocument();
	Document sectorDocument = new PlainDocument();
	Document functionDocument = new PlainDocument();
	Document exchangeDocument = new PlainDocument();
	Document infoDocument = new PlainDocument();
	Document noticesDocument = new PlainDocument();
	
	public CompanyPanel()
	{
		try
		{
			jbInit();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	void jbInit() throws Exception
	{
		this.setLayout(gridBagLayout1);
		jTextArea1.setMinimumSize(new Dimension(320, 48));
		jTextArea1.setPreferredSize(new Dimension(320, 48));
		jTextArea1.setDocument(infoDocument);
		jTextArea2.setMinimumSize(new Dimension(320, 48));
		jTextArea2.setPreferredSize(new Dimension(320, 48));
		jTextArea2.setDocument(noticesDocument);
		jPanel2.setLayout(gridBagLayout2);
		jTextField1.setMinimumSize(new Dimension(120, 21));
		jTextField1.setPreferredSize(new Dimension(120, 21));
		jTextField1.setDocument(IDDocument);
		jTextField2.setMinimumSize(new Dimension(120, 21));
		jTextField2.setPreferredSize(new Dimension(120, 21));
		jTextField2.setDocument(nameDocument);
		jTextField3.setMinimumSize(new Dimension(120, 21));
		jTextField3.setPreferredSize(new Dimension(120, 21));
		jTextField3.setDocument(sectorDocument);
		jTextField4.setMinimumSize(new Dimension(120, 21));
		jTextField4.setPreferredSize(new Dimension(120, 21));
		jTextField4.setDocument(functionDocument);
		jTextField5.setMinimumSize(new Dimension(120, 21));
		jTextField5.setPreferredSize(new Dimension(120, 21));
		jTextField5.setInputVerifier(floatVerifier);
		jTextField5.setDocument(exchangeDocument);
		jTextField6.setMinimumSize(new Dimension(120, 21));
		jTextField6.setPreferredSize(new Dimension(120, 21));
		jLabel1.setText("ID:");
		jLabel2.setText("Name:");
		jLabel3.setText("Sector:");
		jLabel4.setText("Function:");
		jLabel5.setText("Exchange:");
		jLabel6.setText("Client since:");
		jLabel7.setText("Contact preson:");
		jLabel8.setMaximumSize(new Dimension(240, 17));
		jLabel8.setMinimumSize(new Dimension(120, 17));
		jLabel8.setPreferredSize(new Dimension(120, 17));
		jLabel8.addMouseListener(new CompanyPanel_jLabel8_mouseAdapter(this));
		IDDocument.addUndoableEditListener(new CompanyPanel_IDDocument_undoableEditAdapter(this));
		nameDocument.addUndoableEditListener(new CompanyPanel_nameDocument_undoableEditAdapter(this));
		sectorDocument.addUndoableEditListener(new CompanyPanel_sectorDocument_undoableEditAdapter(this));
		functionDocument.addUndoableEditListener(new CompanyPanel_functionDocument_undoableEditAdapter(this));
		exchangeDocument.addUndoableEditListener(new CompanyPanel_exchangeDocument_undoableEditAdapter(this));
		jTextField6.addDateSelectionListener(new CompanyPanel_sinceDocument_dateSelectionAdapter(this));
		infoDocument.addUndoableEditListener(new CompanyPanel_infoDocument_undoableEditAdapter(this));
		noticesDocument.addUndoableEditListener(new CompanyPanel_noticesDocument_undoableEditAdapter(this));
		this.add(jPanel1, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jTabbedPane1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
		jTabbedPane1.add(jTextArea1,   "Short information");
		jTabbedPane1.add(jTextArea2,   "Notices");
		this.add(jPanel2,new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 16), 0, 0));
		jPanel2.add(jTextField2,new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		jPanel2.add(jTextField3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		jPanel2.add(jTextField4, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		jPanel2.add(jTextField5,new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		jPanel2.add(jTextField6, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		jPanel2.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(18, 0, 18, 4), 0, 0));
		jPanel2.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
		jPanel2.add(jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
		jPanel2.add(jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
		jPanel2.add(jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
		jPanel2.add(jTextField1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(18, 2, 18, 2), 0, 0));
		jPanel2.add(jLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 2, 4), 0, 0));
		jPanel2.add(jLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
		jPanel2.add(jLabel8, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
	}
	
	public void setElement(Ancestor value)
	{
		if (value == null)
		{
			value = new CompanyT();
		}
		super.setElement(value);
		CompanyT company = (CompanyT) value;
		jTextField1.setText(company.getShortName());
		jTextField2.setText(company.getName());
		jTextField3.setText(company.getSector());
		jTextField4.setText(company.getFunction());
		jTextField5.setText(String.valueOf(company.getExchange()));
		jTextField6.setSelectedDate(company.getClientSince().toDate());
		jTextArea1.setText(company.getShortInformation());
		jTextArea2.setText(company.getNotices());
		jPanel1.setElement(company.getContact());
		if (company.getContactPerson() != null)
		{
			jLabel8.setText(company.getContactPerson().toString());
		}
		else
		{
			jLabel8.setText("none");
		}
	}
	
	protected void updateAccess()
	{
		boolean editable = (mode != AncestorDialog.VIEW_MODE);
		jTextField1.setEditable(mode == AncestorDialog.ADD_MODE);
		jTextField2.setEditable(editable);
		jTextField3.setEditable(editable);
		jTextField4.setEditable(editable);
		jTextField5.setEditable(editable);
		jTextField6.setEnabled(editable);
		jTextArea1.setEditable(editable);
		jTextArea2.setEditable(editable);
		jPanel1.setMode(mode);
	}
	
	void IDDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		company.setShortName(jTextField1.getText());
	}
	
	void nameDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		company.setName(jTextField2.getText());
	}
	
	void sectorDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		company.setSector(jTextField3.getText());
	}
	
	void functionDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		company.setFunction(jTextField4.getText());
	}
	
	void exchangeDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		try
		{
			company.setExchange(Float.parseFloat(jTextField5.getText()));
		}
		catch(NumberFormatException ex)
		{
		}
	}
	
	void sinceDocument_dateSelectionHappened(DateSelectionEvent e)
	{
		CompanyT company = (CompanyT) element;
		Date d = jTextField6.getSelectedDate();
		company.setClientSince(new DateT(d));
	}
	
	void infoDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		company.setShortInformation(jTextArea1.getText());
	}
	
	void noticesDocument_undoableEditHappened(UndoableEditEvent e)
	{
		CompanyT company = (CompanyT) element;
		company.setNotices(jTextArea2.getText());
	}
	
	void jLabel8_mouseClicked(MouseEvent e)
	{
		if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
		{
			AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
			CompanyListT myList = (CompanyListT) myDialog.getList();
			AncestorDialog dialog = new AncestorDialog(null, "Contact person", true);
			dialog.setList(myList.getClientList());
			dialog.setPanel(new ClientPanel());
			CompanyT company = (CompanyT) element;
			ClientT person = company.getContactPerson();
			if (person != null)
			{
				dialog.show(false, new Long(person.getIDNumber()));
			}
			else
			{
				dialog.show(false);
			}
			company.setContactPerson((ClientT)dialog.getSelected());
			if (company.getContactPerson() != null)
			{
				jLabel8.setText(company.getContactPerson().toString());
			}
			else
			{
				jLabel8.setText("none");
			}
		}
	}
	
}

class CompanyPanel_IDDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_IDDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.IDDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_nameDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_nameDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.nameDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_sectorDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_sectorDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.sectorDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_functionDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_functionDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.functionDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_exchangeDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_exchangeDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.exchangeDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_sinceDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
	CompanyPanel adaptee;
	
	CompanyPanel_sinceDocument_dateSelectionAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void dateSelectionChanged(DateSelectionEvent e)
	{
		adaptee.sinceDocument_dateSelectionHappened(e);
	}
}

class CompanyPanel_infoDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_infoDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.infoDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_noticesDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
	CompanyPanel adaptee;
	
	CompanyPanel_noticesDocument_undoableEditAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void undoableEditHappened(UndoableEditEvent e)
	{
		adaptee.noticesDocument_undoableEditHappened(e);
	}
}

class CompanyPanel_jLabel8_mouseAdapter extends java.awt.event.MouseAdapter
{
	CompanyPanel adaptee;
	
	CompanyPanel_jLabel8_mouseAdapter(CompanyPanel adaptee)
	{
		this.adaptee = adaptee;
	}
	public void mouseClicked(MouseEvent e)
	{
		adaptee.jLabel8_mouseClicked(e);
	}
}
