package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;

import javax.swing.JLabel;

import semorg.booking.CompanyBookingListT;
import semorg.booking.CompanyBookingT;
import semorg.classes.Ancestor;
import semorg.company.CompanyT;
import semorg.presentation.CompanyPresentationT;

public class CompanyBookingPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  BookingPanel jPanel1 = new BookingPanel();

  public CompanyBookingPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    jLabel1.setText("Ordering party:");
    this.setLayout(gridBagLayout1);
    jLabel3.setText("Presentation:");
    jLabel2.setMinimumSize(new Dimension(120, 21));
    jLabel2.setPreferredSize(new Dimension(120, 21));
    jLabel2.addMouseListener(new CompanyBookingPanel_jLabel2_mouseAdapter(this));
    jLabel4.setMinimumSize(new Dimension(120, 21));
    jLabel4.setPreferredSize(new Dimension(120, 21));
    jLabel4.addMouseListener(new CompanyBookingPanel_jLabel4_mouseAdapter(this));
    this.add(jLabel1,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    this.add(jLabel2,    new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jLabel3,    new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 16, 2, 4), 0, 0));
    this.add(jLabel4,    new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jPanel1,   new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new CompanyBookingT();
    }
    super.setElement(value);
    CompanyBookingT booking = (CompanyBookingT) value;
    if (booking.getOrderingParty() != null)
    {
      jLabel2.setText(booking.getOrderingParty().toString());
    }
    else
    {
      jLabel2.setText("none");
    }
    if (booking.getPresentation() != null)
    {
      jLabel4.setText(booking.getPresentation().toString());
    }
    else
    {
      jLabel4.setText("none");
    }
    jPanel1.setElement(booking);
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    if (editable)
    {
    }
    else
    {
    }
    jPanel1.setMode(mode);
  }

  void jLabel2_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      CompanyBookingListT myList = (CompanyBookingListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Ordering party", true);
      dialog.setList(myList.getCompanyList());
      dialog.setPanel(new CompanyPanel());
      CompanyBookingT booking = (CompanyBookingT) element;
      CompanyT company = booking.getOrderingParty();
      if (company != null)
      {
        dialog.show(false, company.getShortName());
      }
      else
      {
        dialog.show(false);
      }
      booking.setOrderingParty((CompanyT)dialog.getSelected());
      if (booking.getOrderingParty() != null)
      {
        jLabel2.setText(booking.getOrderingParty().toString());
      }
      else
      {
        jLabel2.setText("none");
      }
    }
  }

  void jLabel4_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      CompanyBookingListT myList = (CompanyBookingListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Presentation", true);
      dialog.setList(myList.getPresentationList());
      dialog.setPanel(new CompanyPresentationPanel());
      CompanyBookingT booking = (CompanyBookingT) element;
      CompanyPresentationT presentation = booking.getPresentation();
      if (presentation != null)
      {
        dialog.show(false, new Long(presentation.getIDNumber()));
      }
      else
      {
        dialog.show(false);
      }
      booking.setPresentation((CompanyPresentationT)dialog.getSelected());
      if (booking.getPresentation() != null)
      {
        jLabel4.setText(booking.getPresentation().toString());
      }
      else
      {
        jLabel4.setText("none");
      }
    }
  }

}

class CompanyBookingPanel_jLabel2_mouseAdapter extends java.awt.event.MouseAdapter
{
  CompanyBookingPanel adaptee;

  CompanyBookingPanel_jLabel2_mouseAdapter(CompanyBookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel2_mouseClicked(e);
  }
}

class CompanyBookingPanel_jLabel4_mouseAdapter extends java.awt.event.MouseAdapter
{
  CompanyBookingPanel adaptee;

  CompanyBookingPanel_jLabel4_mouseAdapter(CompanyBookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel4_mouseClicked(e);
  }
}
