package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.presentation.ClientPresentationT;
import semorg.presentation.CompanyPresentationT;

public class ClientPresentationPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JTextField jTextField4 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  PresentationPanel jPanel1 = new PresentationPanel();
  InputVerifier integerVerifier = new IntegerVerifier();
  InputVerifier floatVerifier = new FloatVerifier();
  Document partnerDocument = new PlainDocument();
  Document cancelDocument = new PlainDocument();
  Document minDocument = new PlainDocument();
  Document actualDocument = new PlainDocument();

  public ClientPresentationPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jLabel1.setText("Partner:");
    jLabel2.setText("Cancel fee:");
    jLabel3.setText("Minimum:");
    jLabel4.setText("Actual:");
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(partnerDocument);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setInputVerifier(floatVerifier);
    jTextField2.setDocument(cancelDocument);
    jTextField4.setMinimumSize(new Dimension(120, 21));
    jTextField4.setPreferredSize(new Dimension(120, 21));
    jTextField4.setInputVerifier(integerVerifier);
    jTextField4.setDocument(actualDocument);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField3.setInputVerifier(integerVerifier);
    jTextField3.setDocument(minDocument);
    partnerDocument.addUndoableEditListener(new ClientPresentationPanel_partnerDocument_undoableEditAdapter(this));
    cancelDocument.addUndoableEditListener(new ClientPresentationPanel_cancelDocument_undoableEditAdapter(this));
    minDocument.addUndoableEditListener(new ClientPresentationPanel_minDocument_undoableEditAdapter(this));
    actualDocument.addUndoableEditListener(new ClientPresentationPanel_actualDocument_undoableEditAdapter(this));
    this.add(jTextField1,      new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jTextField2,      new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel1,     new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    this.add(jLabel2,     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3,      new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 16, 2, 4), 0, 0));
    this.add(jLabel4,     new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 16, 2, 4), 0, 0));
    this.add(jTextField3,     new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jTextField4,   new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jPanel1,   new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new ClientPresentationT();
    }
    super.setElement(value);
    ClientPresentationT presentation = (ClientPresentationT) value;
    jTextField1.setText(presentation.getPartner());
    jTextField2.setText(String.valueOf(presentation.getCancelFee()));
    jTextField3.setText(String.valueOf(presentation.getParticipiantMin()));
    jTextField4.setText(String.valueOf(presentation.getParticipiantActual()));
    jPanel1.setElement(presentation);
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextField2.setEditable(editable);
    jTextField3.setEditable(editable);
    jTextField4.setEditable(editable);
    jPanel1.setMode(mode);
  }

  void partnerDocument_undoableEditHappened(UndoableEditEvent e)
  {
    CompanyPresentationT presentation = (CompanyPresentationT) element;
    presentation.setGlobalPrice(Float.parseFloat(jTextField1.getText()));
  }

  void cancelDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ClientPresentationT presentation = (ClientPresentationT) element;
    try
    {
      presentation.setCancelFee(Float.parseFloat(jTextField2.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void minDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ClientPresentationT presentation = (ClientPresentationT) element;
    try
    {
      presentation.setParticipiantMin(Integer.parseInt(jTextField3.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

  void actualDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ClientPresentationT presentation = (ClientPresentationT) element;
    try
    {
      presentation.setParticipiantActual(Integer.parseInt(jTextField4.getText()));
    }
    catch (NumberFormatException ex)
    {
    }
  }

}

class ClientPresentationPanel_partnerDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ClientPresentationPanel adaptee;

  ClientPresentationPanel_partnerDocument_undoableEditAdapter(ClientPresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.partnerDocument_undoableEditHappened(e);
  }
}

class ClientPresentationPanel_cancelDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ClientPresentationPanel adaptee;

  ClientPresentationPanel_cancelDocument_undoableEditAdapter(ClientPresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.cancelDocument_undoableEditHappened(e);
  }
}

class ClientPresentationPanel_minDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ClientPresentationPanel adaptee;

  ClientPresentationPanel_minDocument_undoableEditAdapter(ClientPresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.minDocument_undoableEditHappened(e);
  }
}

class ClientPresentationPanel_actualDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ClientPresentationPanel adaptee;

  ClientPresentationPanel_actualDocument_undoableEditAdapter(ClientPresentationPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.actualDocument_undoableEditHappened(e);
  }
}
