package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.ImageIcon;



import semorg.classes.Ancestor;
import semorg.company.CompanyT;
import semorg.person.ClientListT;
import semorg.person.ClientT;


public class ClientPanel extends AncestorPanel
{
  //ImageIcon icon1 = new ImageIcon(MainFrame.class.getResource("SemOrgBig.gif")); 
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  PersonPanel jPanel1 = new PersonPanel();
  JTextField jTextField1 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel Slika = new JLabel();
  JLabel jLabel2 = new JLabel();
  JTextField jTextField2 = new JTextField();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  InputVerifier floatVerifier = new FloatVerifier();
  Document functionDocument = new PlainDocument();
  Document exchangeDocument = new PlainDocument();
  public ClientPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jLabel1.setText("Function:");
    jLabel2.setText("Exchange:");
    jTextField1.setMinimumSize(new Dimension(100, 21));
    jTextField1.setPreferredSize(new Dimension(100, 21));
    jTextField1.setDocument(functionDocument);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setInputVerifier(floatVerifier);
    jTextField2.setDocument(exchangeDocument);
    jLabel3.setToolTipText("");
    jLabel3.setText("Company:");
    jLabel4.setMaximumSize(new Dimension(240, 17));
    jLabel4.setMinimumSize(new Dimension(120, 17));
    jLabel4.setPreferredSize(new Dimension(120, 17));
    jLabel4.addMouseListener(new ClientPanel_jLabel4_mouseAdapter(this));
    functionDocument.addUndoableEditListener(new ClientPanel_functionDocument_undoableEditAdapter(this));
    exchangeDocument.addUndoableEditListener(new ClientPanel_exchangeDocument_undoableEditAdapter(this));
    //this.setBackground(Color.white);
    
    
    this.add(Slika, new GridBagConstraints(0, 0, 1, 1, 0, 100
            ,GridBagConstraints.NORTH, GridBagConstraints.NORTH, new Insets(0, 0, 0, 0), 0, 0));
            
    
    this.add(jTextField1,       new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
   
    
    //jLabel1.setBackground(Color.white);
    this.add(jLabel1,       new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    //jLabel2.setBackground(Color.white);
    this.add(jLabel2,        new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 16, 2, 4), 0, 0));
   
    this.add(jTextField2,       new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    //jPanel1.setBackground(Color.white);
    this.add(jPanel1,    new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));    
    this.add(jLabel3,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    
    this.add(jLabel4,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));           
   
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new ClientT();
    }
    super.setElement(value);
    ClientT client = (ClientT) value;
    jPanel1.setElement(client);
    jTextField1.setText(client.getFunction());
    jTextField2.setText(String.valueOf(client.getExchange()));
    if (client.getCompany() != null)
    {
      jLabel4.setText(client.getCompany().toString());
    }
    else
    {
      jLabel4.setText("none");
    }
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextField2.setEditable(editable);
    jPanel1.setMode(mode);
  }

  void functionDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ClientT client = (ClientT) element;
    client.setFunction(jTextField1.getText());
  }

  void exchangeDocument_undoableEditHappened(UndoableEditEvent e)
  {
    ClientT client = (ClientT) element;
    try
    {
      float f = Float.parseFloat(jTextField2.getText());
      client.setExchange(f);
    }
    catch(IllegalArgumentException ex)
    {
    }
  }

  void jLabel4_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      ClientListT myList = (ClientListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Company", true);
      dialog.setList(myList.getCompanyList());
      dialog.setPanel(new CompanyPanel());
      ClientT client = (ClientT) element;
      CompanyT company = client.getCompany();
      if (company != null)
      {
        dialog.show(false, company.getShortName());
      }
      else
      {
        dialog.show(false);
      }
      client.setCompany((CompanyT)dialog.getSelected());
      if (client.getCompany() != null)
      {
        jLabel4.setText(client.getCompany().toString());
      }
      else
      {
        jLabel4.setText("none");
      }
    }
  }

}

class ClientPanel_functionDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ClientPanel adaptee;

  ClientPanel_functionDocument_undoableEditAdapter(ClientPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.functionDocument_undoableEditHappened(e);
  }
}

class ClientPanel_exchangeDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  ClientPanel adaptee;

  ClientPanel_exchangeDocument_undoableEditAdapter(ClientPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.exchangeDocument_undoableEditHappened(e);
  }
}

class ClientPanel_jLabel4_mouseAdapter extends java.awt.event.MouseAdapter
{
  ClientPanel adaptee;

  ClientPanel_jLabel4_mouseAdapter(ClientPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel4_mouseClicked(e);
  }
}