package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;

import javax.swing.JLabel;

import semorg.booking.ClientBookingListT;
import semorg.booking.ClientBookingT;
import semorg.classes.Ancestor;
import semorg.person.ClientT;
import semorg.presentation.ClientPresentationT;

public class ClientBookingPanel extends AncestorPanel
{

  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();
  JLabel jLabel8 = new JLabel();
  BookingPanel jPanel1 = new BookingPanel();

  public ClientBookingPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    jLabel1.setText("Customer:");
    this.setLayout(gridBagLayout1);
    jLabel2.setText("Participiant:");
    jLabel3.setText("Substitute:");
    jLabel7.setText("Presentation:");
    jLabel4.setMinimumSize(new Dimension(120, 21));
    jLabel4.setPreferredSize(new Dimension(120, 21));
    jLabel4.addMouseListener(new ClientBookingPanel_jLabel4_mouseAdapter(this));
    jLabel5.setMinimumSize(new Dimension(120, 21));
    jLabel5.setPreferredSize(new Dimension(120, 21));
    jLabel5.addMouseListener(new ClientBookingPanel_jLabel5_mouseAdapter(this));
    jLabel6.setMinimumSize(new Dimension(120, 21));
    jLabel6.setPreferredSize(new Dimension(120, 21));
    jLabel6.addMouseListener(new ClientBookingPanel_jLabel6_mouseAdapter(this));
    jLabel8.setMinimumSize(new Dimension(120, 21));
    jLabel8.setPreferredSize(new Dimension(120, 21));
    jLabel8.addMouseListener(new ClientBookingPanel_jLabel8_mouseAdapter(this));
    this.add(jLabel1,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    this.add(jLabel2,    new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel4,    new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jLabel5,    new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel6,    new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel7,    new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 16, 2, 4), 0, 0));
    this.add(jLabel8,     new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jPanel1,   new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new ClientBookingT();
    }
    super.setElement(value);
    ClientBookingT booking = (ClientBookingT) value;
    jPanel1.setElement(booking);
    if (booking.getCustomer() != null)
    {
      jLabel4.setText(booking.getCustomer().toString());
    }
    else
    {
      jLabel4.setText("none");
    }
    if (booking.getParticipiant() != null)
    {
      jLabel5.setText(booking.getParticipiant().toString());
    }
    else
    {
      jLabel5.setText("none");
    }
    if (booking.getSubstitute() != null)
    {
      jLabel6.setText(booking.getSubstitute().toString());
    }
    else
    {
      jLabel6.setText("none");
    }
    if (booking.getPresentation() != null)
    {
      jLabel8.setText(booking.getPresentation().toString());
    }
    else
    {
      jLabel8.setText("none");
    }
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    if (editable)
    {
    }
    else
    {
    }
    jPanel1.setMode(mode);
  }

  void jLabel4_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      ClientBookingListT myList = (ClientBookingListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Customer", true);
      dialog.setList(myList.getClientList());
      dialog.setPanel(new ClientPanel());
      ClientBookingT booking = (ClientBookingT) element;
      ClientT client = booking.getCustomer();
      if (client != null)
      {
        dialog.show(false, new Long(client.getIDNumber()));
      }
      else
      {
        dialog.show(false);
      }
      booking.setCustomer((ClientT)dialog.getSelected());
      if (booking.getCustomer() != null)
      {
        jLabel4.setText(booking.getCustomer().toString());
      }
      else
      {
        jLabel4.setText("none");
      }
    }
  }

  void jLabel5_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      ClientBookingListT myList = (ClientBookingListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Participiant", true);
      dialog.setList(myList.getClientList());
      dialog.setPanel(new ClientPanel());
      ClientBookingT booking = (ClientBookingT) element;
      ClientT client = booking.getParticipiant();
      if (client != null)
      {
        dialog.show(false, new Long(client.getIDNumber()));
      }
      else
      {
        dialog.show(false);
      }
      booking.setParticipiant((ClientT)dialog.getSelected());
      if (booking.getParticipiant() != null)
      {
        jLabel5.setText(booking.getParticipiant().toString());
      }
      else
      {
        jLabel5.setText("none");
      }
    }
  }

  void jLabel6_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      ClientBookingListT myList = (ClientBookingListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Substitute", true);
      dialog.setList(myList.getClientList());
      dialog.setPanel(new ClientPanel());
      ClientBookingT booking = (ClientBookingT) element;
      ClientT client = booking.getSubstitute();
      if (client != null)
      {
        dialog.show(false, new Long(client.getIDNumber()));
      }
      else
      {
        dialog.show(false);
      }
      booking.setSubstitute((ClientT)dialog.getSelected());
      if (booking.getSubstitute() != null)
      {
        jLabel6.setText(booking.getSubstitute().toString());
      }
      else
      {
        jLabel6.setText("none");
      }
    }
  }

  void jLabel8_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      ClientBookingListT myList = (ClientBookingListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Presentation", true);
      dialog.setList(myList.getPresentationList());
      dialog.setPanel(new ClientPresentationPanel());
      ClientBookingT booking = (ClientBookingT) element;
      ClientPresentationT presentation = booking.getPresentation();
      if (presentation != null)
      {
        dialog.show(false, new Long(presentation.getIDNumber()));
      }
      else
      {
        dialog.show(false);
      }
      booking.setPresentation((ClientPresentationT)dialog.getSelected());
      if (booking.getPresentation() != null)
      {
        jLabel8.setText(booking.getPresentation().toString());
      }
      else
      {
        jLabel8.setText("none");
      }
    }
  }

}

class ClientBookingPanel_jLabel4_mouseAdapter extends java.awt.event.MouseAdapter
{
  ClientBookingPanel adaptee;

  ClientBookingPanel_jLabel4_mouseAdapter(ClientBookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel4_mouseClicked(e);
  }
}

class ClientBookingPanel_jLabel5_mouseAdapter extends java.awt.event.MouseAdapter
{
  ClientBookingPanel adaptee;

  ClientBookingPanel_jLabel5_mouseAdapter(ClientBookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel5_mouseClicked(e);
  }
}

class ClientBookingPanel_jLabel6_mouseAdapter extends java.awt.event.MouseAdapter
{
  ClientBookingPanel adaptee;

  ClientBookingPanel_jLabel6_mouseAdapter(ClientBookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel6_mouseClicked(e);
  }
}

class ClientBookingPanel_jLabel8_mouseAdapter extends java.awt.event.MouseAdapter
{
  ClientBookingPanel adaptee;

  ClientBookingPanel_jLabel8_mouseAdapter(ClientBookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel8_mouseClicked(e);
  }
}
