package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;

import javax.swing.JLabel;
import semorg.classes.Ancestor;
import semorg.person.DocentT;
import semorg.seminar.CanConductListT;
import semorg.seminar.CanConductT;
import semorg.seminar.SeminarT;
import semorg.gui.AncestorDialog;

public class CanConductPanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();

  public CanConductPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    
    jLabel1.setText("Docent:");
    this.setLayout(gridBagLayout1);
    jLabel2.setText("Seminar:");
    jLabel3.setMinimumSize(new Dimension(120, 21));
    jLabel3.setPreferredSize(new Dimension(120, 21));
    jLabel3.addMouseListener(new CanConductPanel_jLabel3_mouseAdapter(this));
    jLabel4.setMinimumSize(new Dimension(120, 21));
    jLabel4.setPreferredSize(new Dimension(120, 21));
    jLabel4.addMouseListener(new CanConductPanel_jLabel4_mouseAdapter(this));
    this.add(jLabel1,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel2,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3,   new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel4,   new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    
    
    
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new CanConductT();
    }
    super.setElement(value);
    CanConductT link = (CanConductT) value;
    if (link.getDocent() != null)
    {
      jLabel3.setText(link.getDocent().toString());
    }
    else
    {
      jLabel3.setText("none");
    }
    if (link.getSeminar() != null)
    {
      jLabel4.setText(link.getSeminar().toString());
    }
    else
    {
      jLabel4.setText("none");
    }
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    if (editable)
    {
    }
    else
    {
    }
   
  }

  void jLabel3_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      CanConductListT myList = (CanConductListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Docent", true);
      dialog.setList(myList.getDocentList());
      dialog.setPanel(new DocentPanel());
      CanConductT link = (CanConductT) element;
      DocentT docent = link.getDocent();
      if (docent != null)
      {
        dialog.show(false, new Long(docent.getIDNumber()));
      }
      else
      {
        dialog.show(false);
      }
      link.setDocent((DocentT)dialog.getSelected());
      if (link.getDocent() != null)
      {
        jLabel3.setText(link.getDocent().toString());
      }
      else
      {
        jLabel3.setText("none");
      }
    }
  }

  void jLabel4_mouseClicked(MouseEvent e)
  {
    if ((e.getClickCount() == 2) && (mode != AncestorDialog.VIEW_MODE))
    {
      AncestorDialog myDialog = (AncestorDialog) getTopLevelAncestor();
      CanConductListT myList = (CanConductListT) myDialog.getList();
      AncestorDialog dialog = new AncestorDialog(null, "Sminar", true);
      dialog.setList(myList.getSeminarList());
      dialog.setPanel(new SeminarPanel());
      CanConductT link = (CanConductT) element;
      SeminarT seminar = link.getSeminar();
      if (seminar != null)
      {
        dialog.show(false, seminar.getShortName());
      }
      else
      {
        dialog.show(false);
      }
      link.setSeminar((SeminarT)dialog.getSelected());
      if (link.getSeminar() != null)
      {
        jLabel4.setText(link.getSeminar().toString());
      }
      else
      {
        jLabel4.setText("none");
      }
    }
  }

}

class CanConductPanel_jLabel3_mouseAdapter extends java.awt.event.MouseAdapter
{
  CanConductPanel adaptee;

  CanConductPanel_jLabel3_mouseAdapter(CanConductPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel3_mouseClicked(e);
  }
}

class CanConductPanel_jLabel4_mouseAdapter extends java.awt.event.MouseAdapter
{
  CanConductPanel adaptee;

  CanConductPanel_jLabel4_mouseAdapter(CanConductPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e)
  {
    adaptee.jLabel4_mouseClicked(e);
  }
}
