package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.booking.BookingT;
import semorg.classes.Ancestor;
import semorg.classes.DateT;

import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.event.DateSelectionEvent;

public class BookingPanel extends AncestorPanel
{

  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JDatePicker jTextField2 = new JDatePicker();
  JDatePicker jTextField3 = new JDatePicker();
  JDatePicker jTextField4 = new JDatePicker();
  JDatePicker jTextField5 = new JDatePicker();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JDatePicker jTextField6 = new JDatePicker();
  JLabel jLabel6 = new JLabel();
  Document IDDocument = new PlainDocument();

  public BookingPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jLabel1.setText("ID:");
    jLabel2.setToolTipText("");
    jLabel2.setText("Registered:");
    jLabel3.setText("Confirmation:");
    jLabel4.setText("Bill:");
    jLabel5.setText("Checked out:");
    jLabel6.setText("Notification:");
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(IDDocument);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField4.setMinimumSize(new Dimension(120, 21));
    jTextField4.setPreferredSize(new Dimension(120, 21));
    jTextField5.setMinimumSize(new Dimension(120, 21));
    jTextField5.setPreferredSize(new Dimension(120, 21));
    jTextField6.setMinimumSize(new Dimension(120, 21));
    jTextField6.setPreferredSize(new Dimension(120, 21));
    IDDocument.addUndoableEditListener(new BookingPanel_IDDocument_undoableEditAdapter(this));
    jTextField2.addDateSelectionListener(new BookingPanel_regDocument_dateSelectionAdapter(this));
    jTextField3.addDateSelectionListener(new BookingPanel_confirmDocument_dateSelectionAdapter(this));
    jTextField4.addDateSelectionListener(new BookingPanel_billDocument_dateSelectionAdapter(this));
    jTextField5.addDateSelectionListener(new BookingPanel_checkOutDocument_dateSelectionAdapter(this));
    jTextField6.addDateSelectionListener(new BookingPanel_notifyDocument_dateSelectionAdapter(this));
    this.add(jTextField1,    new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 18, 2), 0, 0));
    this.add(jTextField2,    new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField3,    new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField4,    new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField5,    new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel1,    new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 18, 4), 0, 0));
    this.add(jLabel2,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3,   new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel4,   new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel5,   new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jTextField6,   new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel6,   new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new BookingT();
    }
    super.setElement(value);
    BookingT booking = (BookingT) value;
    jTextField1.setText(String.valueOf(booking.getIDNumber()));
    jTextField2.setSelectedDate(booking.getRegistered().toDate());
    jTextField3.setSelectedDate(booking.getConfirmation().toDate());
    jTextField4.setSelectedDate(booking.getBill().toDate());
    jTextField5.setSelectedDate(booking.getCheckedOut().toDate());
    jTextField6.setSelectedDate(booking.getNotification().toDate());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(mode == AncestorDialog.ADD_MODE);
    jTextField2.setEnabled(editable);
    jTextField3.setEnabled(editable);
    jTextField4.setEnabled(editable);
    jTextField5.setEnabled(editable);
    jTextField6.setEnabled(editable);
  }

  void IDDocument_undoableEditHappened(UndoableEditEvent e)
  {
    BookingT booking = (BookingT) element;
    try
    {
      booking.setIDNumber(Integer.parseInt(jTextField1.getText()));
    }
    catch(NumberFormatException ex)
    {
    }
  }

  void regDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    BookingT booking = (BookingT) element;
    Date d = jTextField2.getSelectedDate();
    booking.setRegistered(new DateT(d));
  }

  void confirmDocument_dateSelectionHappened(DateSelectionEvent e)
  {
  	BookingT booking = (BookingT) element;
  	Date d = jTextField3.getSelectedDate();
  	booking.setConfirmation(new DateT(d));
  }

  void billDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    BookingT booking = (BookingT) element;
    Date d = jTextField4.getSelectedDate();
    booking.setBill(new DateT(d));
  }

  void checkOutDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    BookingT booking = (BookingT) element;
    Date d = jTextField5.getSelectedDate();
    booking.setCheckedOut(new DateT(d));
  }

  void notifyDocument_dateSelectionHappened(DateSelectionEvent e)
  {
    BookingT booking = (BookingT) element;
    Date d = jTextField6.getSelectedDate();
    booking.setNotification(new DateT(d));
  }

}

class BookingPanel_IDDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  BookingPanel adaptee;

  BookingPanel_IDDocument_undoableEditAdapter(BookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.IDDocument_undoableEditHappened(e);
  }
}

class BookingPanel_regDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  BookingPanel adaptee;

  BookingPanel_regDocument_dateSelectionAdapter(BookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.regDocument_dateSelectionHappened(e);
  }
}

class BookingPanel_confirmDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  BookingPanel adaptee;

  BookingPanel_confirmDocument_dateSelectionAdapter(BookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.confirmDocument_dateSelectionHappened(e);
  }
}

class BookingPanel_billDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  BookingPanel adaptee;

  BookingPanel_billDocument_dateSelectionAdapter(BookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.billDocument_dateSelectionHappened(e);
  }
}

class BookingPanel_checkOutDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  BookingPanel adaptee;

  BookingPanel_checkOutDocument_dateSelectionAdapter(BookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.checkOutDocument_dateSelectionHappened(e);
  }
}

class BookingPanel_notifyDocument_dateSelectionAdapter extends com.standbysoft.datepicker.event.DateSelectionAdapter
{
  BookingPanel adaptee;

  BookingPanel_notifyDocument_dateSelectionAdapter(BookingPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void dateSelectionChanged(DateSelectionEvent e)
  {
    adaptee.notifyDocument_dateSelectionHappened(e);
  }
}
