package semorg.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.Ancestor;
import semorg.person.AssociateT;
import semorg.person.ClientT;

public class AssociatePanel extends AncestorPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  PersonPanel jPanel1 = new PersonPanel();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  Document occupationDocument = new PlainDocument();
  Document entitlementDocument = new PlainDocument();
  Document passwordDocument = new PlainDocument();

  public AssociatePanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception
  {
    this.setLayout(gridBagLayout1);
    jLabel1.setText("Ocupation:");
    jLabel2.setText("Entitlement:");
    jLabel3.setText("Password:");
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(occupationDocument);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setDocument(entitlementDocument);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField3.setDocument(passwordDocument);
    occupationDocument.addUndoableEditListener(new AssociatePanel_occupationDocument_undoableEditAdapter(this));
    entitlementDocument.addUndoableEditListener(new AssociatePanel_entitlementDocument_undoableEditAdapter(this));
    passwordDocument.addUndoableEditListener(new AssociatePanel_passwordDocument_undoableEditAdapter(this));
    this.add(jTextField1,       new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jTextField2,      new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel1,     new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 0, 2, 4), 0, 0));
    this.add(jLabel2,     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jTextField3,     new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 2, 2, 2), 0, 0));
    this.add(jLabel3,      new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 16, 2, 4), 0, 0));
    this.add(jPanel1,   new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new AssociateT();
    }
    super.setElement(value);
    AssociateT associate = (AssociateT) value;
    jPanel1.setElement(associate);
    jTextField1.setText(associate.getOccupation());
    jTextField1.setText(associate.getEntitlement());
    jTextField1.setText(associate.getPassword());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextField2.setEditable(editable);
    jTextField3.setEditable(editable);
    jPanel1.setMode(mode);
  }

  void occupationDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AssociateT associate = (AssociateT) element;
    associate.setOccupation(jTextField1.getText());
  }

  void entitlementDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AssociateT associate = (AssociateT) element;
    associate.setEntitlement(jTextField1.getText());
  }

  void passwordDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AssociateT associate = (AssociateT) element;
    associate.setPassword(jTextField1.getText());
  }

}

class AssociatePanel_occupationDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AssociatePanel adaptee;

  AssociatePanel_occupationDocument_undoableEditAdapter(AssociatePanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.occupationDocument_undoableEditHappened(e);
  }
}

class AssociatePanel_entitlementDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AssociatePanel adaptee;

  AssociatePanel_entitlementDocument_undoableEditAdapter(AssociatePanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.entitlementDocument_undoableEditHappened(e);
  }
}

class AssociatePanel_passwordDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AssociatePanel adaptee;

  AssociatePanel_passwordDocument_undoableEditAdapter(AssociatePanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.passwordDocument_undoableEditHappened(e);
  }
}
