package semorg.gui;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;



import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import javax.swing.ImageIcon;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;

import semorg.company.CompanyT;
import semorg.person.ClientT;




import semorg.classes.Ancestor;
import semorg.classes.List;

public class AncestorDialog extends JDialog
{
  

  JPanel mainPanel = new JPanel();
  GridBagLayout grid1 = new GridBagLayout();
  GridBagConstraints constraints = new GridBagConstraints();
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel ButtonPanel = new JPanel();
  JSplitPane splitPane = new JSplitPane();
  JPanel ListPanel = new JPanel();
  JLabel listLabel = new JLabel();
  
  ImageIcon Add = new ImageIcon(MainFrame.class.getResource("Add.gif"));
  JButton addButton = new JButton(Add);
  
  ImageIcon edit = new ImageIcon(MainFrame.class.getResource("Edit.gif"));
  JButton editButton = new JButton(edit);
  

  
  ImageIcon rem = new ImageIcon(MainFrame.class.getResource("Rem.gif"));
  JButton removeButton = new JButton(rem);
  
  ImageIcon done = new ImageIcon(MainFrame.class.getResource("Done.gif"));
  JButton doneButton = new JButton(done);
  
  AncestorPanel panel = new AncestorPanel();
  ListSelectionModel listSelectionModel1 = new DefaultListSelectionModel();
  JScrollPane jScrollPane1 = new JScrollPane();
  BorderLayout borderLayout2 = new BorderLayout();
  JList elementList = new JList();
  Border border1;
  JPanel jPanel1 = new JPanel();
  JButton noneButton = new JButton();
  
  
  ImageIcon q = new ImageIcon(MainFrame.class.getResource("q.gif"));
  JButton SQLButton = new JButton(q);
  JComboBox SQLMenu1  = new JComboBox();
  JComboBox SQLMenu2 = new JComboBox();
  JTextField SQLTF = new JTextField("",10);
  
  
  
  
  
  
  
  public static final int VIEW_MODE = 0;
  public static final int EDIT_MODE = 1;
  public static final int ADD_MODE = 2;

  private List list;
  private boolean editable;
  private int mode;
  private boolean selected;

  
  public void setA(){
    editable = false;
  }
  public AncestorDialog(Frame frame, String title, boolean modal)
  {
    super(frame, title, modal);
    try
    {
      jbInit();
      pack();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  public AncestorDialog()
  {
    this(null, "", false);
  }
  
  
  void Napravi(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
     gbc.gridx = gx;
     gbc.gridy = gy;
     gbc.gridwidth = gw;
     gbc.gridheight = gh;
     gbc.weightx = wx;
     gbc.weighty = wy;	
}
  void jbInit() throws Exception
  {
    
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    

    
    border1 = BorderFactory.createBevelBorder(BevelBorder.LOWERED,Color.white,Color.white,new Color(165, 163, 151),new Color(115, 114, 105));
    mainPanel.setLayout(borderLayout1);
    ListPanel.setLayout(borderLayout2);
    listLabel.setText("Select one for details:");
    //splitPane.setResizeWeight(1.0);
    
    addButton.setText("Add");
    addButton.addActionListener(new AncestorDialog_addButton_actionAdapter(this));
    addButton.setFocusPainted(false); 
    editButton.setText("Edit");
    editButton.addActionListener(new AncestorDialog_editButton_actionAdapter(this));
    editButton.setFocusPainted(false); 
    
    removeButton.setText("Remove");
    removeButton.addActionListener(new AncestorDialog_removeButton_actionAdapter(this));
    removeButton.setFocusPainted(false); 
    
    doneButton.setText("Done");
    doneButton.addActionListener(new AncestorDialog_doneButton_actionAdapter(this));
    doneButton.setFocusPainted(false); 
    
    listSelectionModel1.addListSelectionListener(new AncestorDialog_listSelectionModel1_listSelectionAdapter(this));
    mainPanel.setPreferredSize(new Dimension(795, 500));
    elementList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    elementList.setSelectionModel(listSelectionModel1);
    jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
    noneButton.setText("None");
    noneButton.addActionListener(new AncestorDialog_noneButton_actionAdapter(this));
    
    getContentPane().add(mainPanel,  BorderLayout.CENTER);
    mainPanel.add(ButtonPanel, BorderLayout.SOUTH);
    ButtonPanel.add(addButton, null);
    ButtonPanel.add(editButton, null);
    ButtonPanel.add(removeButton, null);
    ButtonPanel.add(doneButton, null);
    mainPanel.add(splitPane,  BorderLayout.CENTER);
    splitPane.add(ListPanel, JSplitPane.LEFT);
    ListPanel.add(jScrollPane1,  BorderLayout.CENTER);
    jScrollPane1.getViewport().add(elementList, null);
    ListPanel.setMinimumSize(new Dimension(350, 21));
    ListPanel.add(listLabel, BorderLayout.NORTH);
    splitPane.add(panel, JSplitPane.RIGHT);
    ListPanel.add(jPanel1,  BorderLayout.SOUTH);
    
    jPanel1.setLayout(grid1);
    
    Napravi(constraints, 0,0,1,1,100,100);
    constraints.fill = GridBagConstraints.BOTH;
    grid1.setConstraints(noneButton,constraints);
    noneButton.setMinimumSize(new Dimension(100, 21));
    jPanel1.add(noneButton, null);
    
    
    Napravi(constraints, 1,0,1,1,100,100);
    constraints.fill = GridBagConstraints.BOTH;
    SQLMenu1.addItem("Uslov1");
    SQLMenu1.addItem("Uslov2");
    SQLMenu1.addItem("Uslov3");
    SQLMenu1.setMinimumSize(new Dimension(80, 18));
    grid1.setConstraints(SQLMenu1,constraints);
    constraints.fill = GridBagConstraints.BOTH;
    jPanel1.add(SQLMenu1);
    
    Napravi(constraints, 2,0,1,1,100,100);
    constraints.fill = GridBagConstraints.BOTH;
    SQLMenu2.addItem("<");
    SQLMenu2.addItem(">");
    SQLMenu2.addItem("<=");
    SQLMenu2.addItem(">=");
    SQLMenu2.addItem("!=");
    SQLMenu2.addItem("~");
    SQLMenu2.addItem("=");
    SQLMenu2.setMinimumSize(new Dimension(60, 18));
    grid1.setConstraints(SQLMenu2,constraints);
    jPanel1.add(SQLMenu2);
    
    
    
    
    Napravi(constraints, 3,0,1,1,100,100);
    constraints.fill = GridBagConstraints.BOTH;
    grid1.setConstraints(SQLTF,constraints);
    SQLTF.setMinimumSize(new Dimension(100, 18));
    
    //jTextField1.setMinimumSize(new Dimension(120, 21));
    constraints.fill = GridBagConstraints.CENTER; 
    jPanel1.add(SQLTF);
    SQLButton.setMinimumSize(new Dimension(30, 18));
    SQLButton.addActionListener(new AncestorDialog_SQLButton_actionAdapter(this));
    
    Napravi(constraints, 4,0,1,1,100,100);
    grid1.setConstraints(SQLButton,constraints);
    jPanel1.add(SQLButton);

      
  }

  private void find(Object key)
  {
    if (key != null)
    {
      Ancestor a = list.find(key);
      elementList.setSelectedValue(a, true);
    }
  }

  private void populate()
  {
    panel.setElement(null);
    if (list != null)
    {
      int n = list.count();
      Ancestor [] a = new Ancestor[n];
      for (int i = 0; i < n; i++)
      {
        a[i] = list.get(i);
      }
      elementList.setListData(a);
    }
    else
    {
      Object [] a = new Object[0];
      elementList.setListData(a);
    }
    updateSelection(null);
  }
 
 
 
 private void populate2()
  {
    panel.setElement(null);
    if (list != null)
    {
      int n = list.count();
      Ancestor [] a = new Ancestor[n];
      for (int i = 0; i < n; i++)
      {
        a[i] = list.get(i);
      }
      elementList.setListData(a);
    }
    else
    {
      Object [] a = new Object[0];
      elementList.setListData(a);
    }
    updateSelection(null);
  }
  
  
  
  
  private void updateSelection(Object selected)
  {
    this.selected = (selected != null);
    if (selected != null)
    {
      panel.setElement((Ancestor)selected);
      removeButton.setEnabled(true);
    }
    else
    {
      panel.setElement(null);
      removeButton.setEnabled(false);
    }
    updateAccess();
  }

  private void updateAccess()
  {
    panel.setMode(mode);
    boolean enabled = (mode == VIEW_MODE);
    addButton.setEnabled(enabled && editable);
    editButton.setEnabled(enabled && editable && selected);
    removeButton.setEnabled(enabled && editable && selected);
  }

  public void setList(List value)
  {
    list = value;
    populate();
  }

  public List getList()
  {
    return list;
  }

  public void setPanel(AncestorPanel value)
  {
    splitPane.remove(panel);
    panel = value;
    splitPane.add(panel, JSplitPane.RIGHT);
  }

  public Ancestor getSelected()
  {
    return panel.getElement();
  }

  public void setMode(int value)
  {
    mode = value;
    updateAccess();
  }

  public void show(boolean editable)
  {
    show(editable, null);
  }

  public void show(boolean editable, Object key)
  {
    this.editable = editable;
    mode = VIEW_MODE;
    updateAccess();
    find(key);
    show();
  }

  void listSelectionModel1_valueChanged(ListSelectionEvent e)
  {
    updateSelection(elementList.getSelectedValue());
  }

  void doneButton_actionPerformed(ActionEvent e)
  {
    if (mode == ADD_MODE)
    {
      Ancestor a = panel.getElement();
      list.add(a);
      populate();
      find(a.getKey());
    }
    else if (mode == EDIT_MODE)
    {
      Ancestor a = panel.getElement();
      list.modify(a);
      populate();
      find(a.getKey());
    }
    else
    {
      this.hide();
    }
    
    mode = VIEW_MODE;
    updateAccess();
    
   
    
  }

  void noneButton_actionPerformed(ActionEvent e)
  {
    updateSelection(null);
  }

  void addButton_actionPerformed(ActionEvent e)
  {
    mode = ADD_MODE;
    panel.setElement(null);
    updateAccess();
  }

  void editButton_actionPerformed(ActionEvent e)
  {
    mode = EDIT_MODE;
    updateAccess();
  }

  void removeButton_actionPerformed(ActionEvent e)
  {
    Ancestor a = panel.getElement();
    list.remove(a.getKey());
    populate();
    find(null);
  }
  
   void SQLButton_actionPerformed(ActionEvent e)
  {  
   
  }
  
}

class AncestorDialog_listSelectionModel1_listSelectionAdapter implements javax.swing.event.ListSelectionListener
{
  AncestorDialog adaptee;

  AncestorDialog_listSelectionModel1_listSelectionAdapter(AncestorDialog adaptee)
  {
    this.adaptee = adaptee;
  }
  public void valueChanged(ListSelectionEvent e)
  {
    adaptee.listSelectionModel1_valueChanged(e);
  }
}

class AncestorDialog_doneButton_actionAdapter implements java.awt.event.ActionListener
{
  AncestorDialog adaptee;

  AncestorDialog_doneButton_actionAdapter(AncestorDialog adaptee)
  {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e)
  {
    adaptee.doneButton_actionPerformed(e);
  }
}

class AncestorDialog_noneButton_actionAdapter implements java.awt.event.ActionListener
{
  AncestorDialog adaptee;

  AncestorDialog_noneButton_actionAdapter(AncestorDialog adaptee)
  {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e)
  {
    adaptee.noneButton_actionPerformed(e);
  }
}

class AncestorDialog_addButton_actionAdapter implements java.awt.event.ActionListener
{
  AncestorDialog adaptee;

  AncestorDialog_addButton_actionAdapter(AncestorDialog adaptee)
  {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e)
  {
    adaptee.addButton_actionPerformed(e);
  }
}

class AncestorDialog_editButton_actionAdapter implements java.awt.event.ActionListener
{
  AncestorDialog adaptee;

  AncestorDialog_editButton_actionAdapter(AncestorDialog adaptee)
  {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e)
  {
    adaptee.editButton_actionPerformed(e);
  }
}

class AncestorDialog_removeButton_actionAdapter implements java.awt.event.ActionListener
{
  AncestorDialog adaptee;

  AncestorDialog_removeButton_actionAdapter(AncestorDialog adaptee)
  {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e)
  {
    adaptee.removeButton_actionPerformed(e);
  }
}
