package semorg.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import semorg.classes.AddressT;
import semorg.classes.Ancestor;

public class AddressPanel extends AncestorPanel
{

  TitledBorder titledBorder1;
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JTextField jTextField4 = new JTextField();
  JTextField jTextField5 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  Document countryDocument = new PlainDocument();
  Document provinceDocument = new PlainDocument();
  Document townDocument = new PlainDocument();
  Document streetDocument = new PlainDocument();
  Document buildingDocument = new PlainDocument();

  public AddressPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  void jbInit() throws Exception
  {
    titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),"Address");
    jTextField1.setMinimumSize(new Dimension(120, 21));
    jTextField1.setPreferredSize(new Dimension(120, 21));
    jTextField1.setDocument(countryDocument);
    this.setLayout(gridBagLayout1);
    this.setBorder(titledBorder1);
    jTextField2.setMinimumSize(new Dimension(120, 21));
    jTextField2.setPreferredSize(new Dimension(120, 21));
    jTextField2.setDocument(provinceDocument);
    jTextField3.setMinimumSize(new Dimension(120, 21));
    jTextField3.setPreferredSize(new Dimension(120, 21));
    jTextField3.setDocument(townDocument);
    jTextField4.setMinimumSize(new Dimension(120, 21));
    jTextField4.setPreferredSize(new Dimension(120, 21));
    jTextField4.setDocument(streetDocument);
    jTextField5.setMinimumSize(new Dimension(120, 21));
    jTextField5.setPreferredSize(new Dimension(120, 21));
    jTextField5.setDocument(buildingDocument);
    jLabel1.setText("Country:");
    jLabel2.setText("Province:");
    jLabel3.setText("Town:");
    jLabel4.setText("Street:");
    jLabel5.setText("Building:");
    countryDocument.addUndoableEditListener(new AddressPanel_countryDocument_undoableEditAdapter(this));
    provinceDocument.addUndoableEditListener(new AddressPanel_provinceDocument_undoableEditAdapter(this));
    townDocument.addUndoableEditListener(new AddressPanel_townDocument_undoableEditAdapter(this));
    streetDocument.addUndoableEditListener(new AddressPanel_streetDocument_undoableEditAdapter(this));
    buildingDocument.addUndoableEditListener(new AddressPanel_buildingDocument_undoableEditAdapter(this));
    this.add(jTextField1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField3, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField4, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jTextField5, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    this.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
    this.add(jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 0, 2, 4), 0, 0));
  }

  public void setElement(Ancestor value)
  {
    if (value == null)
    {
      value = new AddressT();
    }
    super.setElement(value);
    AddressT address = (AddressT) value;
    jTextField1.setText(address.getCountry());
    jTextField2.setText(address.getProvince());
    jTextField3.setText(address.getTown());
    jTextField4.setText(address.getStreet());
    jTextField5.setText(address.getBuilding());
  }

  protected void updateAccess()
  {
    boolean editable = (mode != AncestorDialog.VIEW_MODE);
    jTextField1.setEditable(editable);
    jTextField2.setEditable(editable);
    jTextField3.setEditable(editable);
    jTextField4.setEditable(editable);
    jTextField5.setEditable(editable);
  }

  void countryDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AddressT address = (AddressT) element;
    address.setCountry(jTextField1.getText());
  }

  void provinceDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AddressT address = (AddressT) element;
    address.setProvince(jTextField2.getText());
  }

  void townDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AddressT address = (AddressT) element;
    address.setTown(jTextField3.getText());
  }

  void streetDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AddressT address = (AddressT) element;
    address.setStreet(jTextField4.getText());
  }

  void buildingDocument_undoableEditHappened(UndoableEditEvent e)
  {
    AddressT address = (AddressT) element;
    address.setBuilding(jTextField5.getText());
  }

}

class AddressPanel_countryDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AddressPanel adaptee;

  AddressPanel_countryDocument_undoableEditAdapter(AddressPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.countryDocument_undoableEditHappened(e);
  }
}

class AddressPanel_provinceDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AddressPanel adaptee;

  AddressPanel_provinceDocument_undoableEditAdapter(AddressPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.provinceDocument_undoableEditHappened(e);
  }
}

class AddressPanel_townDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AddressPanel adaptee;

  AddressPanel_townDocument_undoableEditAdapter(AddressPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.townDocument_undoableEditHappened(e);
  }
}

class AddressPanel_streetDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AddressPanel adaptee;

  AddressPanel_streetDocument_undoableEditAdapter(AddressPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.streetDocument_undoableEditHappened(e);
  }
}

class AddressPanel_buildingDocument_undoableEditAdapter implements javax.swing.event.UndoableEditListener
{
  AddressPanel adaptee;

  AddressPanel_buildingDocument_undoableEditAdapter(AddressPanel adaptee)
  {
    this.adaptee = adaptee;
  }
  public void undoableEditHappened(UndoableEditEvent e)
  {
    adaptee.buildingDocument_undoableEditHappened(e);
  }
}