
package semorg.company;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.ContactT;
import semorg.classes.DataBaseT;
import semorg.classes.DateT;
import semorg.classes.List;
import semorg.person.ClientListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CompanyListT extends List
{

  /**
   * The associated list.
   */

  private ClientListT clientList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public CompanyListT(Connection DBConnection)
  {
    super(DBConnection);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */


  
  public CompanyListT(DataBaseT database)
  {
    super(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String companyTableName = "Company";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String companyTableKeyName = "ShortName";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "ShortName, " +
           prefix + "Name, " +
           ContactT.tableColumns(prefix) + ", " +
           prefix + "ContactPerson, " +
           prefix + "Sector, " +
           prefix + "Function, " +
           prefix + "ShortInformation, " +
           prefix + "Notices, " +
           prefix + "Exchange, " +
           DateT.tableColumns(prefix + "ClientSince");
  }

  public String toString()
  {
    return "List of " + count() + " companies";
  }

  public boolean create()
  {
    return create(companyTableName, CompanyT.SQLCreateString(""));
  }

  public boolean destroy()
  {
    return destroy(companyTableName);
  }

  public boolean add(Ancestor element)
  {
    return add(companyTableName, tableColumns(""), element.toSQLAddString());
  }

  public boolean remove(Object key)
  {
    return remove(companyTableName, companyTableKeyName, key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(companyTableName, companyTableKeyName, element.toSQLModifyString(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(companyTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(companyTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      CompanyT Company = new CompanyT(Result, 1);
      database.close(Result);
      Company.setClientList(clientList);
      return Company;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(companyTableName, companyTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        CompanyT Company = new CompanyT(Result, 1);
        database.close(Result);
        Company.setClientList(clientList);
        return Company;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setClientList(ClientListT value)
  {
    this.clientList = value;
  }

  public ClientListT getClientList()
  {
    return clientList;
  }
  
}
