
package semorg.classes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;

/**
 * Instances of this class represent dates used by other classes.
 *
 * @author Ivan Pribela
 * @version 1.1
 */

public class TimeT extends Ancestor
{

  /**
   * Holds information about the date.
   */

  private int hours, minutes, timezone;

  /**
   * Constructs a new instance of <code>TimeT</code> class.
   */

  public TimeT()
  {
    hours = 8;
    minutes = 0;
    timezone = 1;
  }

  /**
   * Constructs a new instance of <code>TimeT</code> class.
   */

  public TimeT(int hours, int minutes, int timezone)
  {
    this.hours = hours;
    this.minutes = minutes;
    this.timezone = timezone;
  }

  /**
   * Constructs a new instance of <code>TimeT</code> class.
   *
   * @param SQL database row from which to read attributes.
   * @param Column starting column in database from which to read
   *     attributes.
   */

  public TimeT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      hours = SQL.getInt(Column); Column++;
      minutes = SQL.getInt(Column); Column++;
      timezone = SQL.getInt(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns string containing names of all columns in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string containing names of all columns in the database.
   */

  public static final String tableColumns(String prefix)
  {
     return prefix + "HoursTime, " +
            prefix + "MinutesTime, " +
            prefix + "TimezoneTime";
  }

  /**
   * Returns number of table columns in database.
   *
   * @return number of table columns in database.
   */

  public static int noOfSQLColumns()
  {
    return 3;
  }

  /**
   * Returns string representation that is used for creating the corresponding table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *      table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "HoursTime int, " +
           prefix + "MinutesTime int, " +
           prefix + "TimezoneTime int";
  }

  /**
   * Returns string representation of this instance that is used for adding it to the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for adding it
   *      to the database.
   */

  public String toSQLAddString()
  {
    return "" + getHours() + ", " +
           "" + getMinutes() + ", " +
           "" + getTimezone() + "";
  }

  /**
   * Returns string representation of this instance that is used for modifying its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *      its attributes it the database.
   */

  public String toSQLModifyString(String prefix)
  {
    return prefix + "HoursTime = " + getHours() + ", " +
           prefix + "MinutesTime = " + getMinutes() + ", " +
           prefix + "TimezoneTime = " + getTimezone() + "";
  }

  /**
   * Returns string representation of this instance.
   *
   * @return string representation of this instance.
   */

  public String toString()
  {
    return hours + ":" + minutes + "(" + timezone + ")";
  }

  /**
   * Returns first name of the contained name.
   *
   * @return first name of the contained name.
   */

  public int getHours()
  {
    return hours;
  }

  /**
   * Returns last name of the contained name.
   *
   * @return last name of the contained name.
   */

  public int getMinutes()
  {
    return minutes;
  }

  /**
   * Returns middle name of the contained name.
   *
   * @return middle name of the contained name.
   */

  public int getTimezone()
  {
    return timezone;
  }

  /**
   * Sets first name of the contained name.
   *
   * @param value new first name for the contained name.
   */

  public void setHours(int value)
  {
    hours = value;
  }

  /**
   * Sets last name of the contained name.
   *
   * @param value new last name for the contained name.
   */

  public void setMinutes(int value)
  {
    minutes = value;
  }

  /**
   * Sets midle name of the contained name.
   *
   * @param value new middle name for the contained name.
   */

  public void setTimezone(int value)
  {
    timezone = value;
  }

  public Object getKey()
  {
    return null;
  }
  
  public void setTime(Time value) {
  	hours = value.getYear();
  	minutes = value.getMonth();
  	timezone = value.getDay();
  }

  public static TimeT valueOf(String string) throws IllegalArgumentException 
  {
  	int hours = 0;
  	int minutes = 0;
  	int gmt = 1;
  	int i = string.indexOf(':');
  	if (i != -1)
  	{
  		hours = Integer.parseInt(string.substring(0, i));
  	}
  	else
  	{
  		throw new IllegalArgumentException();
  	}
  	int j = string.indexOf('(');
  	if (j != -1)
  	{
  		minutes = Integer.parseInt(string.substring(i + 1, j));
  		i = string.indexOf(')');
  		if (i != -1)
  		{ 
  			gmt = Integer.parseInt(string.substring(j + 1, i));
  		}
  		else
  		{
  			throw new IllegalArgumentException();
  		}
  	}
  	else
  	{
  		minutes = Integer.parseInt(string.substring(i + 1));
  	}
	return new TimeT(hours, minutes, gmt);
  }

}