
package semorg.classes;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Instances of this class represent names used by other classes.
 *
 * @author Ivan Pribela
 * @version 1.1
 */

public class NameT extends Ancestor
{

  /**
   * Holds information about the name.
   */

  private String First, Last, Middle;

  /**
   * Constructs a new instance of <code>NameT</code> class.
   */

  public NameT()
  {
    First = "";
    Last = "";
    Middle = "";
  }

  /**
   * Constructs a new instance of <code>NameT</code> class.
   */

  public NameT(String First, String Last, String Middle)
  {
    this.First = First;
    this.Last = Last;
    this.Middle = Middle;
  }

  /**
   * Constructs a new instance of <code>NameT</code> class.
   *
   * @param SQL database row from which to read attributes.
   * @param Column starting column in database from which to read
   *     attributes.
   */

  public NameT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      First = SQL.getString(Column); Column++;
      Last = SQL.getString(Column); Column++;
      Middle = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns string containing names of all columns in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string containing names of all columns in the database.
   */

  public static final String tableColumns(String prefix)
  {
     return prefix + "FirstName, " +
            prefix + "LastName, " +
            prefix + "MiddleName";
  }

  /**
   * Returns number of table columns in database.
   *
   * @return number of table columns in database.
   */

  public static int noOfSQLColumns()
  {
    return 3;
  }

  /**
   * Returns string representation that is used for creating the corresponding table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *      table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "FirstName varchar(30), " +
           prefix + "LastName varchar(30), " +
           prefix + "MiddleName varchar(30)";
  }

  /**
   * Returns string representation of this instance that is used for adding it to the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for adding it
   *      to the database.
   */

  public String toSQLAddString()
  {
    return "'" + getFirst() + "', " +
           "'" + getLast() + "', " +
           "'" + getMiddle() + "'";
  }

  /**
   * Returns string representation of this instance that is used for modifying its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *      its attributes it the database.
   */

  public String toSQLModifyString(String prefix)
  {
    return prefix + "FirstName = '" + getFirst() + "', " +
           prefix + "LastName = '" + getLast() + "', " +
           prefix + "MiddleName = '" + getMiddle() + "'";
  }

  /**
   * Returns string representation of this instance.
   *
   * @return string representation of this instance.
   */

  public String toString()
  {
    return First + " " + Middle + " " + Last;
  }

  /**
   * Returns first name of the contained name.
   *
   * @return first name of the contained name.
   */

  public String getFirst()
  {
    return First;
  }

  /**
   * Returns last name of the contained name.
   *
   * @return last name of the contained name.
   */

  public String getLast()
  {
    return Last;
  }

  /**
   * Returns middle name of the contained name.
   *
   * @return middle name of the contained name.
   */

  public String getMiddle()
  {
    return Middle;
  }

  /**
   * Sets first name of the contained name.
   *
   * @param value new first name for the contained name.
   */

  public void setFirst(String value)
  {
    First = value;
  }

  /**
   * Sets last name of the contained name.
   *
   * @param value new last name for the contained name.
   */

  public void setLast(String value)
  {
    Last = value;
  }

  /**
   * Sets midle name of the contained name.
   *
   * @param value new middle name for the contained name.
   */

  public void setMiddle(String value)
  {
    Middle = value;
  }

  public Object getKey()
  {
    return null;
  }

}