
package semorg.classes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

/**
 * Instances of this class represent dates used by other classes.
 *
 * @author Ivan Pribela
 * @version 1.1
 */

public class DateT extends Ancestor
{

  /**
   * Holds information about the date.
   */

  private int year, month, day;

  /**
   * Constructs a new instance of <code>DateT</code> class.
   */

  public DateT()
  {  
    year = 1001;
    month = 01;
    day = 01; 
  }

  /**
   * Constructs a new instance of <code>DateT</code> class.
   */

  public DateT(int year, int month, int day)
  {
    this.year = year;
    this.month = month;
    this.day = day;
  }

  /**
   * Constructs a new instance of <code>DateT</code> class.
   *
   * @param SQL database row from which to read attributes.
   * @param Column starting column in database from which to read
   *     attributes.
   */

  public DateT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      year = SQL.getInt(Column); Column++;
      month = SQL.getInt(Column); Column++;
      day = SQL.getInt(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  public DateT(long currentTime) {
	this(new Date(currentTime));
  }

  public DateT(Date d) {
  	this(d.getYear(), d.getMonth(), d.getDate());
  }

  /**
   * Returns string containing names of all columns in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string containing names of all columns in the database.
   */

  public static final String tableColumns(String prefix)
  {
     return prefix + "YearDate, " +
            prefix + "MonthDate, " +
            prefix + "DayDate";
  }

  /**
   * Returns number of table columns in database.
   *
   * @return number of table columns in database.
   */

  public static int noOfSQLColumns()
  {
    return 3;
  }

  /**
   * Returns string representation that is used for creating the corresponding table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *      table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "YearDate int, " +
           prefix + "MonthDate int, " +
           prefix + "DayDate int";
  }

  /**
   * Returns string representation of this instance that is used for adding it to the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for adding it
   *      to the database.
   */

  public String toSQLAddString()
  {
    return "" + getYear() + ", " +
           "" + getMonth() + ", " +
           "" + getDay() + "";
  }

  /**
   * Returns string representation of this instance that is used for modifying its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *      its attributes it the database.
   */

  public String toSQLModifyString(String prefix)
  {
    return prefix + "YearDate = " + getYear() + ", " +
           prefix + "MonthDate = " + getMonth() + ", " +
           prefix + "DayDate = " + getDay() + "";
  }

  /**
   * Returns string representation of this instance.
   *
   * @return string representation of this instance.
   */

  public String toString()
  {
    return day + ". " + month + ". " + year + ".";
  }

  /**
   * Returns first name of the contained name.
   *
   * @return first name of the contained name.
   */

  public int getYear()
  {
    return year;
  }

  /**
   * Returns last name of the contained name.
   *
   * @return last name of the contained name.
   */

  public int getMonth()
  {
    return month;
  }

  /**
   * Returns middle name of the contained name.
   *
   * @return middle name of the contained name.
   */

  public int getDay()
  {
    return day;
  }

  /**
   * Sets first name of the contained name.
   *
   * @param value new first name for the contained name.
   */

  public void setYear(int value)
  {
    year = value;
  }

  /**
   * Sets last name of the contained name.
   *
   * @param value new last name for the contained name.
   */

  public void setMonth(int value)
  {
    month = value;
  }

  /**
   * Sets midle name of the contained name.
   *
   * @param value new middle name for the contained name.
   */

  public void setDay(int value)
  {
    day = value;
  }

  public Object getKey()
  {
    return null;
  }
  
  public void setDate(Date value) {
  	year = value.getYear();
  	month = value.getMonth();
  	day = value.getDay();
  }

  public Date toDate() {
	return new Date(year, month, day);
  }

}