
package semorg.classes;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Simplifies using of the data base.
 *
 * @author Ivan Pribela
 * @version 1.0
 */        
 
public class DataBaseT extends Object
{

  /**
   * Holds information about the database.
   */

  private Connection DBConn;

  /**
   * Holds information about the database.
   */

  private Statement Stmt;

  /**
   * Creates a new instance of <code>DataBaseT</code> class.
   * 
   * @param DBConnection connection used to comunicate with the database.
   */    
   
  public DataBaseT(Connection DBConnection)
  {
    try
    {
      this.DBConn = DBConnection;
      Stmt = DBConn.createStatement();
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Sends a SQL query to the database.
   * 
   * @param Command SQL command.
   */    
   
  public ResultSet query(String Command)
  // Executes SQL command 'Command'
  {
    System.out.println(Command);
    try
    {
      ResultSet Result = Stmt.executeQuery(Command);
      return Result;
    }
    catch (SQLException e)
    {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * Fries the resources ocupied by a query result.
   */
   
  public boolean close(ResultSet Result)
  {
    if (Result != null)
    {
      try
      {
        Result.close();
      }
      catch (SQLException e)
      {
        return false;
      }
      return true;
    }
    return false;
  }

  /**
   * Sends a DML command to the database.
   * 
   * @param Command DML command.
   */    
   
  public boolean update(String Command)
  // Executes DML command 'Command'
  {
    System.out.println(Command);
    try
    {
      int Rows = Stmt.executeUpdate(Command);
      return Rows != 0;
    }
    catch (SQLException e)
    {
      e.printStackTrace();
      return false;
    }
  }

  /**
   * Fries the resources ocupied by this instance.
   */
   
  public void endSesion()
  {
    try
    {
      Stmt.close();
      DBConn.close();
    }
    catch (SQLException e)
    {
    }
  }

}
